/*
 * Decompiled with CFR 0.152.
 */
package clients;

import authentication.ISymAuth;
import clients.ISymClient;
import clients.symphony.api.ConnectionsClient;
import clients.symphony.api.MessagesClient;
import clients.symphony.api.PresenceClient;
import clients.symphony.api.SignalsClient;
import clients.symphony.api.StreamsClient;
import clients.symphony.api.UsersClient;
import configuration.SymConfig;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import utils.HttpClientBuilderHelper;

public final class SymOBOClient
implements ISymClient {
    private static SymOBOClient oboClient;
    private SymConfig config;
    private ISymAuth symAuth;
    private MessagesClient messagesClient;
    private PresenceClient presenceClient;
    private StreamsClient streamsClient;
    private UsersClient usersClient;
    private ConnectionsClient connectionsClient;
    private SignalsClient signalsClient;
    private Client podClient;
    private Client agentClient;

    public static SymOBOClient initOBOClient(SymConfig config, ISymAuth auth) {
        if (oboClient == null) {
            oboClient = new SymOBOClient(config, auth);
            return oboClient;
        }
        return oboClient;
    }

    private SymOBOClient(SymConfig config, ISymAuth symAuth, ClientConfig podClientConfig, ClientConfig agentClientConfig) {
        this.config = config;
        this.symAuth = symAuth;
        this.podClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)podClientConfig).build();
        this.agentClient = HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)agentClientConfig).build();
    }

    public SymOBOClient(SymConfig config, ISymAuth symAuth) {
        this.config = config;
        this.symAuth = symAuth;
        String proxyURL = !StringUtils.isEmpty((CharSequence)config.getPodProxyURL()) ? config.getPodProxyURL() : config.getProxyURL();
        String proxyUser = !StringUtils.isEmpty((CharSequence)config.getPodProxyUsername()) ? config.getPodProxyUsername() : config.getProxyUsername();
        String proxyPass = !StringUtils.isEmpty((CharSequence)config.getPodProxyPassword()) ? config.getPodProxyPassword() : config.getProxyPassword();
        ClientConfig proxyConfig = new ClientConfig();
        proxyConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
        proxyConfig.property("jersey.config.client.proxy.uri", (Object)proxyURL);
        if (!StringUtils.isEmpty((CharSequence)proxyUser) && !StringUtils.isEmpty((CharSequence)proxyPass)) {
            proxyConfig.property("jersey.config.client.proxy.username", (Object)proxyUser);
            proxyConfig.property("jersey.config.client.proxy.password", (Object)proxyPass);
        }
        this.agentClient = StringUtils.isEmpty((CharSequence)config.getProxyURL()) ? HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build() : HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)proxyConfig).build();
        this.podClient = StringUtils.isEmpty((CharSequence)config.getPodProxyURL()) && StringUtils.isEmpty((CharSequence)config.getProxyURL()) ? HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).build() : HttpClientBuilderHelper.getHttpClientBuilderWithTruststore(config).withConfig((Configuration)proxyConfig).build();
    }

    @Override
    public SymConfig getConfig() {
        return this.config;
    }

    @Override
    public ISymAuth getSymAuth() {
        return this.symAuth;
    }

    @Override
    public MessagesClient getMessagesClient() {
        if (this.messagesClient == null) {
            this.messagesClient = new MessagesClient(this);
        }
        return this.messagesClient;
    }

    @Override
    public PresenceClient getPresenceClient() {
        if (this.presenceClient == null) {
            this.presenceClient = new PresenceClient(this);
        }
        return this.presenceClient;
    }

    @Override
    public StreamsClient getStreamsClient() {
        if (this.streamsClient == null) {
            this.streamsClient = new StreamsClient(this);
        }
        return this.streamsClient;
    }

    @Override
    public UsersClient getUsersClient() {
        if (this.usersClient == null) {
            this.usersClient = new UsersClient(this);
        }
        return this.usersClient;
    }

    @Override
    public ConnectionsClient getConnectionsClient() {
        if (this.connectionsClient == null) {
            this.connectionsClient = new ConnectionsClient(this);
        }
        return this.connectionsClient;
    }

    @Override
    public SignalsClient getSignalsClient() {
        if (this.signalsClient == null) {
            this.signalsClient = new SignalsClient(this);
        }
        return this.signalsClient;
    }

    @Override
    public Client getPodClient() {
        return this.podClient;
    }

    @Override
    public Client getAgentClient() {
        return this.agentClient;
    }

    @Override
    public void setPodClient(Client podClient) {
        this.podClient = podClient;
    }

    @Override
    public void setAgentClient(Client agentClient) {
        this.agentClient = agentClient;
    }
}

