/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import model.AdminNewUser;
import model.AdminStreamFilter;
import model.AdminUserAttributes;
import model.AdminUserInfo;
import model.AdminUserInfoList;
import model.ApplicationEntitlement;
import model.ApplicationEntitlementList;
import model.Avatar;
import model.AvatarList;
import model.FeatureEntitlement;
import model.FeatureEntitlementList;
import model.InboundImportMessageList;
import model.OutboundImportMessageList;
import model.Status;
import model.StringId;
import model.SuppressionResult;
import model.events.AdminStreamInfoList;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AdminClient
extends APIClient {
    private final Logger logger = LoggerFactory.getLogger(AdminClient.class);
    private ISymClient botClient;

    public AdminClient(ISymClient client) {
        this.botClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundImportMessageList importMessages(OutboundImportMessageList messageList) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v4/message/import").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity((Object)messageList, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundImportMessageList inboundImportMessageList = this.importMessages(messageList);
                    if (response != null) {
                        response.close();
                    }
                    return inboundImportMessageList;
                }
                InboundImportMessageList inboundImportMessageList = null;
                return inboundImportMessageList;
            }
            InboundImportMessageList inboundImportMessageList = (InboundImportMessageList)response.readEntity(InboundImportMessageList.class);
            return inboundImportMessageList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SuppressionResult suppressMessage(String id) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/messagesuppression/{id}/suppress".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    SuppressionResult suppressionResult = this.suppressMessage(id);
                    if (response != null) {
                        response.close();
                    }
                    return suppressionResult;
                }
                SuppressionResult suppressionResult = null;
                return suppressionResult;
            }
            SuppressionResult suppressionResult = (SuppressionResult)response.readEntity(SuppressionResult.class);
            return suppressionResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminStreamInfoList listEnterpriseStreams(AdminStreamFilter filter, int skip, int limit) throws SymClientException {
        Object result = null;
        WebTarget builder = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/admin/streams/list");
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        try (Response response = null;){
            response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)filter, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    AdminStreamInfoList adminStreamInfoList = this.listEnterpriseStreams(filter, skip, limit);
                    if (response != null) {
                        response.close();
                    }
                    return adminStreamInfoList;
                }
                AdminStreamInfoList adminStreamInfoList = null;
                return adminStreamInfoList;
            }
            AdminStreamInfoList adminStreamInfoList = (AdminStreamInfoList)response.readEntity(AdminStreamInfoList.class);
            return adminStreamInfoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createIM(List<Long> userIdList) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/im/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(userIdList, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    String string = this.createIM(userIdList);
                    if (response != null) {
                        response.close();
                    }
                    return string;
                }
                String string = null;
                return string;
            }
            String string = ((StringId)response.readEntity(StringId.class)).getId();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminUserInfo getUser(Long uid) throws NoContentException, SymClientException {
        try (Response response = null;){
            AdminUserInfo info;
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/admin/user/{uid}".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    AdminUserInfo adminUserInfo = this.getUser(uid);
                    if (response != null) {
                        response.close();
                    }
                    return adminUserInfo;
                }
                AdminUserInfo adminUserInfo = null;
                return adminUserInfo;
            }
            if (response.getStatus() == 204) {
                throw new NoContentException("No user found.");
            }
            AdminUserInfo adminUserInfo = info = (AdminUserInfo)response.readEntity(AdminUserInfo.class);
            return adminUserInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AdminUserInfo> listUsers(int skip, int limit) throws SymClientException {
        AdminUserInfoList result = null;
        WebTarget builder = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/admin/user/list");
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        try (Response response = null;){
            response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatus() == 200) {
                result = (AdminUserInfoList)response.readEntity(AdminUserInfoList.class);
            }
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<AdminUserInfo> list = this.listUsers(skip, limit);
                    if (response != null) {
                        response.close();
                    }
                    return list;
                }
                List<AdminUserInfo> list = null;
                return list;
            }
            AdminUserInfoList adminUserInfoList = result;
            return adminUserInfoList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminUserInfo createUser(AdminNewUser newUser) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/admin/user/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)newUser, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    AdminUserInfo adminUserInfo = this.createUser(newUser);
                    if (response != null) {
                        response.close();
                    }
                    return adminUserInfo;
                }
                AdminUserInfo adminUserInfo = null;
                return adminUserInfo;
            }
            AdminUserInfo adminUserInfo = (AdminUserInfo)response.readEntity(AdminUserInfo.class);
            return adminUserInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdminUserInfo updateUser(Long userId, AdminUserAttributes userAttributes) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/admin/user/{uid}/update".replace("{uid}", Long.toString(userId))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)userAttributes, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    AdminUserInfo adminUserInfo = this.updateUser(userId, userAttributes);
                    if (response != null) {
                        response.close();
                    }
                    return adminUserInfo;
                }
                AdminUserInfo adminUserInfo = null;
                return adminUserInfo;
            }
            AdminUserInfo adminUserInfo = (AdminUserInfo)response.readEntity(AdminUserInfo.class);
            return adminUserInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Avatar> getAvatar(Long uid) throws SymClientException {
        AvatarList avatar = null;
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/avatar".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<Avatar> list = this.getAvatar(uid);
                    if (response != null) {
                        response.close();
                    }
                    return list;
                }
                List<Avatar> list = null;
                return list;
            }
            if (response.getStatus() == 204) {
                throw new SymClientException("No user found for userid:= " + uid);
            }
            AvatarList avatarList = avatar = (AvatarList)response.readEntity(AvatarList.class);
            return avatarList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAvatar(Long userId, String filePath) throws IOException, SymClientException {
        File f = new File(filePath);
        FileInputStream fis = new FileInputStream(f);
        byte[] byteArray = new byte[(int)f.length()];
        fis.read(byteArray);
        String imageString = Base64.encodeBase64String((byte[])byteArray);
        HashMap<String, String> input = new HashMap<String, String>();
        input.put("image", imageString);
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/avatar/update".replace("{uid}", Long.toString(userId))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(input, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.updateAvatar(userId, filePath);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserStatus(Long uid) throws SymClientException {
        String statusString = null;
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/status".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    String string = this.getUserStatus(uid);
                    if (response != null) {
                        response.close();
                    }
                    return string;
                }
                String ex = null;
                return ex;
            }
            if (response.getStatus() == 204) {
                throw new SymClientException("No user found for userid:= " + uid);
            }
            Status status = (Status)response.readEntity(Status.class);
            String string = statusString = status.getStatus();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserStatus(Long uid, String status) throws SymClientException {
        Status statusObj = new Status();
        statusObj.setStatus(status);
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/status/update".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)statusObj, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.updateUserStatus(uid, status);
                }
            } else if (response.getStatus() == 204) {
                throw new SymClientException("No user found for userid:= " + uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listPodFeatures() throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/system/features/list").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<String> list = this.listPodFeatures();
                    if (response != null) {
                        response.close();
                    }
                    return list;
                }
                List<String> list = null;
                return list;
            }
            List list = (List)response.readEntity((GenericType)new GenericType<List<String>>(){});
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FeatureEntitlement> getUserFeatures(Long uid) throws SymClientException {
        try (Response response = null;){
            List featureEntitlements;
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/features".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<FeatureEntitlement> list = this.getUserFeatures(uid);
                    if (response != null) {
                        response.close();
                    }
                    return list;
                }
                List<FeatureEntitlement> list = null;
                return list;
            }
            List list = featureEntitlements = (List)response.readEntity(FeatureEntitlementList.class);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserFeatures(Long uid, List<FeatureEntitlement> entitlements) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/features/update".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(entitlements, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.updateUserFeatures(uid, entitlements);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApplicationEntitlement> getUserApplicationEntitlements(Long uid) throws SymClientException {
        try (Response response = null;){
            List entitlements;
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/app/entitlement/list".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<ApplicationEntitlement> list = this.getUserApplicationEntitlements(uid);
                    if (response != null) {
                        response.close();
                    }
                    return list;
                }
                List<ApplicationEntitlement> list = null;
                return list;
            }
            List list = entitlements = (List)response.readEntity(ApplicationEntitlementList.class);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ApplicationEntitlement> updateUserApplicationEntitlements(Long uid, List<ApplicationEntitlement> entitlementsUpdate) throws SymClientException {
        try (Response response = null;){
            List entitlements;
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/admin/user/{uid}/app/entitlement/list".replace("{uid}", Long.toString(uid))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(entitlementsUpdate, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<ApplicationEntitlement> list = this.updateUserApplicationEntitlements(uid, entitlementsUpdate);
                    if (response != null) {
                        response.close();
                    }
                    return list;
                }
                List<ApplicationEntitlement> list = null;
                return list;
            }
            List list = entitlements = (List)response.readEntity(ApplicationEntitlementList.class);
            return list;
        }
    }
}

