/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import model.InboundConnectionRequest;
import model.InboundConnectionRequestList;

public final class ConnectionsClient
extends APIClient {
    private ISymClient botClient;

    public ConnectionsClient(ISymClient client) {
        this.botClient = client;
    }

    public List<InboundConnectionRequest> getPendingConnections() throws SymClientException {
        return this.getConnections(null, null);
    }

    public List<InboundConnectionRequest> getInboundPendingConnections() throws SymClientException {
        return this.getConnections("PENDING_INCOMING", null);
    }

    public List<InboundConnectionRequest> getAllConnections() throws SymClientException {
        return this.getConnections("ALL", null);
    }

    public List<InboundConnectionRequest> getAcceptedConnections() throws SymClientException {
        return this.getConnections("ACCEPTED", null);
    }

    public List<InboundConnectionRequest> getRejectedConnections() throws SymClientException {
        return this.getConnections("REJECTED", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InboundConnectionRequest> getConnections(String status, List<Long> userIds) throws SymClientException {
        boolean userList = false;
        StringBuilder userIdList = new StringBuilder();
        if (userIds != null && !userIds.isEmpty()) {
            userList = true;
            userIdList.append(userIds.get(0));
            for (int i = 1; i < userIds.size(); ++i) {
                userIdList.append("," + userIds.get(i));
            }
        }
        WebTarget builder = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/connection/list");
        if (status != null) {
            builder = builder.queryParam("status", new Object[]{status});
        }
        if (userList) {
            builder = builder.queryParam("userIds", new Object[]{userIdList.toString()});
        }
        try (Response response = null;){
            response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<InboundConnectionRequest> list = this.getConnections(status, userIds);
                    if (response != null) {
                        response.close();
                    }
                    return list;
                }
                List<InboundConnectionRequest> list = null;
                return list;
            }
            List list = (List)response.readEntity(InboundConnectionRequestList.class);
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundConnectionRequest acceptConnectionRequest(Long userId) throws SymClientException {
        UserId userIdObject = new UserId();
        userIdObject.setUserId(userId);
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/connection/accept").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)userIdObject, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundConnectionRequest inboundConnectionRequest = this.acceptConnectionRequest(userId);
                    if (response != null) {
                        response.close();
                    }
                    return inboundConnectionRequest;
                }
                InboundConnectionRequest inboundConnectionRequest = null;
                return inboundConnectionRequest;
            }
            InboundConnectionRequest inboundConnectionRequest = (InboundConnectionRequest)response.readEntity(InboundConnectionRequest.class);
            return inboundConnectionRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundConnectionRequest rejectConnectionRequest(Long userId) throws SymClientException {
        UserId userIdObject = new UserId();
        userIdObject.setUserId(userId);
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/connection/reject").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)userIdObject, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundConnectionRequest inboundConnectionRequest = this.rejectConnectionRequest(userId);
                    if (response != null) {
                        response.close();
                    }
                    return inboundConnectionRequest;
                }
                InboundConnectionRequest inboundConnectionRequest = null;
                return inboundConnectionRequest;
            }
            InboundConnectionRequest inboundConnectionRequest = (InboundConnectionRequest)response.readEntity(InboundConnectionRequest.class);
            return inboundConnectionRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundConnectionRequest sendConnectionRequest(Long userId) throws SymClientException {
        UserId userIdObject = new UserId();
        userIdObject.setUserId(userId);
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/connection/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity((Object)userIdObject, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundConnectionRequest inboundConnectionRequest = this.sendConnectionRequest(userId);
                    if (response != null) {
                        response.close();
                    }
                    return inboundConnectionRequest;
                }
                InboundConnectionRequest inboundConnectionRequest = null;
                return inboundConnectionRequest;
            }
            InboundConnectionRequest inboundConnectionRequest = (InboundConnectionRequest)response.readEntity(InboundConnectionRequest.class);
            return inboundConnectionRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundConnectionRequest getConnectionRequestStatus(Long userId) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/connection/user/{userId}/info".replace("{userId}", Long.toString(userId))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundConnectionRequest inboundConnectionRequest = this.getConnectionRequestStatus(userId);
                    if (response != null) {
                        response.close();
                    }
                    return inboundConnectionRequest;
                }
                InboundConnectionRequest inboundConnectionRequest = null;
                return inboundConnectionRequest;
            }
            InboundConnectionRequest inboundConnectionRequest = (InboundConnectionRequest)response.readEntity(InboundConnectionRequest.class);
            return inboundConnectionRequest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Long userId) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/connection/user/{userId}/remove".replace("{userId}", Long.toString(userId))).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.removeConnection(userId);
                }
            }
        }
    }

    private class UserId {
        private Long userId;

        private UserId() {
        }

        public Long getUserId() {
            return this.userId;
        }

        public void setUserId(Long userId) {
            this.userId = userId;
        }
    }
}

