/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.SymBotClient;
import clients.symphony.api.APIClient;
import configuration.SymConfig;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import model.DatafeedEvent;
import model.DatafeedEventsList;
import model.StringId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatafeedClient
extends APIClient {
    private final Logger logger = LoggerFactory.getLogger(DatafeedClient.class);
    private SymBotClient botClient;
    private SymConfig config;

    public DatafeedClient(SymBotClient client) {
        this.botClient = client;
        this.config = client.getConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDatafeed() throws SymClientException {
        StringId datafeedId = null;
        try (Response response = null;){
            this.logger.info("Creating new datafeed for bot {} .....", (Object)this.botClient.getBotUserInfo().getUsername());
            response = this.botClient.getAgentClient().target("https://" + this.config.getAgentHost() + ":" + this.config.getAgentPort()).path("/agent/v4/datafeed/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.logger.error("createDatafeed error ", (Throwable)ex);
                    String string = this.createDatafeed();
                    if (response != null) {
                        response.close();
                    }
                    return string;
                }
            } else {
                datafeedId = (StringId)response.readEntity(StringId.class);
                this.logger.info("Created new datafeed {} for bot {}", (Object)datafeedId.getId(), (Object)this.botClient.getBotUserInfo().getUsername());
            }
            String string = datafeedId.getId();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DatafeedEvent> readDatafeed(String id) throws SymClientException {
        List datafeedEvents = null;
        this.logger.debug("Reading datafeed {}", (Object)id);
        try (Response response = null;){
            WebTarget webTarget = this.botClient.getAgentClient().target("https://" + this.config.getAgentHost() + ":" + this.config.getAgentPort());
            response = webTarget.path("/agent/v4/datafeed/{id}/read".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                this.logger.error("Datafeed read error for request " + webTarget.getUri());
                this.handleError(response, this.botClient);
            } else {
                datafeedEvents = response.getStatus() == 204 ? new ArrayList() : (List)response.readEntity(DatafeedEventsList.class);
            }
            ArrayList<DatafeedEvent> arrayList = datafeedEvents;
            return arrayList;
        }
    }
}

