/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.SymBotClient;
import clients.symphony.api.APIClient;
import clients.symphony.api.DatafeedClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import model.DatafeedEvent;
import model.DatafeedEventsList;
import model.StringId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirehoseClient
extends APIClient {
    private final Logger logger = LoggerFactory.getLogger(DatafeedClient.class);
    private SymBotClient botClient;

    public FirehoseClient(SymBotClient client) {
        this.botClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createFirehose() throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v4/firehose/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    String string = this.createFirehose();
                    if (response != null) {
                        response.close();
                    }
                    return string;
                }
                String ex = null;
                return ex;
            }
            StringId firehoseId = (StringId)response.readEntity(StringId.class);
            String string = firehoseId.getId();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DatafeedEvent> readFirehose(String id) throws SymClientException {
        List<DatafeedEvent> firehoseEvents = null;
        try (Response response = null;){
            response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v4/firehose/{id}/read".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                this.handleError(response, this.botClient);
            } else {
                firehoseEvents = response.getStatus() == 204 ? new ArrayList<DatafeedEvent>() : (List)response.readEntity(DatafeedEventsList.class);
            }
            ArrayList<DatafeedEvent> arrayList = firehoseEvents;
            return arrayList;
        }
    }
}

