/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import authentication.SymOBOUserRSAAuth;
import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.io.File;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import model.Attachment;
import model.FileAttachment;
import model.InboundMessage;
import model.InboundMessageList;
import model.InboundShare;
import model.MessageStatus;
import model.OutboundMessage;
import model.OutboundShare;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.BodyPart;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.media.multipart.MultiPartMediaTypes;

public final class MessagesClient
extends APIClient {
    private ISymClient botClient;
    private boolean isKeyManTokenRequired;

    public MessagesClient(ISymClient client) {
        this.botClient = client;
        this.isKeyManTokenRequired = !(this.botClient.getSymAuth() instanceof SymOBOUserRSAAuth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InboundMessage sendMessage(String streamId, OutboundMessage message, boolean appendTags) throws SymClientException {
        Client httpClient = this.botClient.getAgentClient();
        httpClient.register(MultiPartFeature.class);
        httpClient.register(JacksonFeature.class);
        WebTarget target = httpClient.target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v4/stream/{sid}/message/create".replace("{sid}", streamId));
        Invocation.Builder invocationBuilder = target.request().accept(new String[]{"application/json"});
        invocationBuilder = invocationBuilder.header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
        if (this.isKeyManTokenRequired) {
            invocationBuilder = invocationBuilder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
        }
        String messageContent = appendTags ? String.format("<messageML>%s</messageML>", message.getMessage()) : message.getMessage();
        FormDataMultiPart multiPart = new FormDataMultiPart();
        FormDataContentDisposition contentDispMessage = FormDataContentDisposition.name((String)"message").build();
        multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDispMessage, messageContent));
        if (message.getData() != null) {
            File[] contentDispData = FormDataContentDisposition.name((String)"data").build();
            multiPart.bodyPart((BodyPart)new FormDataBodyPart((FormDataContentDisposition)contentDispData, message.getData()));
        }
        if (message.getAttachment() != null && message.getAttachment().length > 0) {
            for (File file : message.getAttachment()) {
                FormDataContentDisposition contentDisp = ((FormDataContentDisposition.FormDataContentDispositionBuilder)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"attachment").fileName(file.getName())).size(file.length())).build();
                multiPart.bodyPart((BodyPart)new FormDataBodyPart(contentDisp, (Object)file, MediaType.APPLICATION_OCTET_STREAM_TYPE));
            }
        }
        Entity entity = Entity.entity((Object)multiPart, (MediaType)MultiPartMediaTypes.createFormData());
        try (Response response = null;){
            response = invocationBuilder.post(entity);
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                InboundMessage inboundMessage = null;
                return inboundMessage;
            }
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundMessage inboundMessage = this.sendMessage(streamId, message, appendTags);
                    if (response != null) {
                        response.close();
                    }
                    return inboundMessage;
                }
                InboundMessage inboundMessage = null;
                return inboundMessage;
            }
            InboundMessage inboundMessage = (InboundMessage)response.readEntity(InboundMessage.class);
            return inboundMessage;
        }
    }

    public InboundMessage forwardMessage(String streamId, InboundMessage message) throws SymClientException {
        OutboundMessage outboundMessage = new OutboundMessage();
        outboundMessage.setMessage(message.getMessage());
        outboundMessage.setData(message.getData());
        return this.sendMessage(streamId, outboundMessage, false);
    }

    public InboundMessage sendMessage(String streamId, OutboundMessage message) throws SymClientException {
        return this.sendMessage(streamId, message, true);
    }

    public InboundMessage sendTaggedMessage(String streamId, OutboundMessage message) throws SymClientException {
        return this.sendMessage(streamId, message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InboundMessage> getMessagesFromStream(String streamId, int since, int skip, int limit) throws SymClientException {
        List result = null;
        WebTarget builder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v4/stream/{sid}/message".replace("{sid}", streamId)).queryParam("since", new Object[]{since});
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        try (Response response = null;){
            Invocation.Builder subBuilder = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
            if (this.isKeyManTokenRequired) {
                subBuilder = subBuilder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
            }
            if ((response = subBuilder.get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<InboundMessage> list = this.getMessagesFromStream(streamId, since, skip, limit);
                    if (response != null) {
                        response.close();
                    }
                    return list;
                }
                List<InboundMessage> list = null;
                return list;
            }
            result = response.getStatus() == 204 ? new ArrayList() : (List)response.readEntity(InboundMessageList.class);
            ArrayList<InboundMessage> arrayList = result;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAttachment(String streamId, String attachmentId, String messageId) throws SymClientException {
        try (Response response = null;){
            Invocation.Builder subBuilder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/stream/{sid}/attachment".replace("{sid}", streamId)).queryParam("fileId", new Object[]{attachmentId}).queryParam("messageId", new Object[]{messageId}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
            if (this.isKeyManTokenRequired) {
                subBuilder = subBuilder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
            }
            if ((response = subBuilder.get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    byte[] byArray = this.getAttachment(streamId, attachmentId, messageId);
                    if (response != null) {
                        response.close();
                    }
                    return byArray;
                }
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = Base64.getDecoder().decode((String)response.readEntity(String.class));
            return byArray;
        }
    }

    public List<FileAttachment> getMessageAttachments(InboundMessage message) throws SymClientException {
        ArrayList<FileAttachment> result = new ArrayList<FileAttachment>();
        if (message.getAttachments() != null) {
            for (Attachment attachment : message.getAttachments()) {
                FileAttachment fileAttachment = new FileAttachment();
                fileAttachment.setFileName(attachment.getName());
                fileAttachment.setSize(attachment.getSize());
                fileAttachment.setFileContent(this.getAttachment(message.getStream().getStreamId(), attachment.getId(), message.getMessageId()));
                result.add(fileAttachment);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageStatus getMessageStatus(String messageId) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/message/{mid}/status".replace("{mid}", messageId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    MessageStatus messageStatus = this.getMessageStatus(messageId);
                    if (response != null) {
                        response.close();
                    }
                    return messageStatus;
                }
                MessageStatus messageStatus = null;
                return messageStatus;
            }
            MessageStatus messageStatus = (MessageStatus)response.readEntity(MessageStatus.class);
            return messageStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundMessageList messageSearch(Map<String, String> query, int skip, int limit, boolean orderAscending) throws SymClientException, NoContentException {
        InboundMessageList result = null;
        WebTarget builder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/message/search");
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        if (orderAscending) {
            builder = builder.queryParam("sortDir", new Object[]{"ASC"});
        }
        try (Response response = null;){
            Invocation.Builder subBuilder = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
            if (this.isKeyManTokenRequired) {
                subBuilder = subBuilder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
            }
            if ((response = subBuilder.post(Entity.entity(query, (String)"application/json"))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundMessageList inboundMessageList = this.messageSearch(query, skip, limit, orderAscending);
                    if (response != null) {
                        response.close();
                    }
                    return inboundMessageList;
                }
                InboundMessageList inboundMessageList = null;
                return inboundMessageList;
            }
            if (response.getStatus() == 204) {
                throw new NoContentException("No messages found");
            }
            InboundMessageList inboundMessageList = result = (InboundMessageList)response.readEntity(InboundMessageList.class);
            return inboundMessageList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InboundShare shareContent(String streamId, OutboundShare shareContent) throws SymClientException {
        HashMap<String, OutboundShare> map = new HashMap<String, OutboundShare>();
        map.put("content", shareContent);
        try (Response response = null;){
            Invocation.Builder subBuilder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v3/stream/{sid}/share".replace("{sid}", streamId)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
            if (this.isKeyManTokenRequired) {
                subBuilder = subBuilder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
            }
            if ((response = subBuilder.post(Entity.entity(map, (String)"application/json"))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    InboundShare inboundShare = this.shareContent(streamId, shareContent);
                    if (response != null) {
                        response.close();
                    }
                    return inboundShare;
                }
                InboundShare inboundShare = null;
                return inboundShare;
            }
            InboundShare inboundShare = (InboundShare)response.readEntity(InboundShare.class);
            return inboundShare;
        }
    }
}

