/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import authentication.SymOBOUserRSAAuth;
import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import model.Signal;
import model.SignalList;
import model.SignalSubscriberList;
import model.SignalSubscriptionResult;

public class SignalsClient
extends APIClient {
    private ISymClient botClient;
    private boolean isKeyManTokenRequired;

    public SignalsClient(ISymClient client) {
        this.botClient = client;
        this.isKeyManTokenRequired = !(this.botClient.getSymAuth() instanceof SymOBOUserRSAAuth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Signal> listSignals(int skip, int limit) throws SymClientException {
        WebTarget builder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/list");
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        try (Response response = null;){
            List<Signal> result;
            Invocation.Builder subBuilder = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
            if (this.isKeyManTokenRequired) {
                subBuilder = subBuilder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
            }
            if ((response = subBuilder.get()).getStatus() == 204) {
                result = new ArrayList<Signal>();
            } else {
                if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                    try {
                        this.handleError(response, this.botClient);
                    }
                    catch (UnauthorizedException ex) {
                        List<Signal> list = this.listSignals(skip, limit);
                        if (response != null) {
                            response.close();
                        }
                        return list;
                    }
                    List<Signal> list = null;
                    return list;
                }
                result = (List)response.readEntity(SignalList.class);
            }
            ArrayList<Signal> arrayList = result;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signal getSignal(String id) throws SymClientException {
        try (Response response = null;){
            Invocation.Builder subBuilder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/get".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
            if (this.isKeyManTokenRequired) {
                subBuilder = subBuilder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
            }
            if ((response = subBuilder.get()).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    Signal signal = this.getSignal(id);
                    if (response != null) {
                        response.close();
                    }
                    return signal;
                }
                Signal signal = null;
                return signal;
            }
            Signal signal = (Signal)response.readEntity(Signal.class);
            return signal;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signal createSignal(Signal signal) throws SymClientException {
        try (Response response = null;){
            Invocation.Builder subBuilder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/create").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken());
            if (this.isKeyManTokenRequired) {
                subBuilder = subBuilder.header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken());
            }
            if ((response = subBuilder.post(Entity.entity((Object)signal, (String)"application/json"))).getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    Signal signal2 = this.createSignal(signal);
                    if (response != null) {
                        response.close();
                    }
                    return signal2;
                }
                Signal signal3 = null;
                return signal3;
            }
            Signal signal4 = (Signal)response.readEntity(Signal.class);
            return signal4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signal updateSignal(Signal signal) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/update".replace("{id}", signal.getId())).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity((Object)signal, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    Signal signal2 = this.updateSignal(signal);
                    if (response != null) {
                        response.close();
                    }
                    return signal2;
                }
                Signal signal3 = null;
                return signal3;
            }
            Signal signal4 = (Signal)response.readEntity(Signal.class);
            return signal4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSignal(String id) throws SymClientException {
        try (Response response = null;){
            response = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/delete".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(null);
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.deleteSignal(id);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalSubscriptionResult subscribeSignal(String id, boolean self, List<Long> uids, boolean pushed) throws SymClientException {
        try (Response response = null;){
            response = self ? this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/subscribe".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(null) : this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/subscribe".replace("{id}", id)).queryParam("pushed", new Object[]{pushed}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity(uids, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    this.subscribeSignal(id, self, uids, pushed);
                }
            }
            SignalSubscriptionResult signalSubscriptionResult = (SignalSubscriptionResult)response.readEntity(SignalSubscriptionResult.class);
            return signalSubscriptionResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public SignalSubscriptionResult unsubscribeSignal(String id, boolean self, List<Long> uids) throws SymClientException {
        try (Response response = null;){
            response = self ? this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/unsubscribe".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(null) : this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/unsubscribe".replace("{id}", id)).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).post(Entity.entity(uids, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                    SignalSubscriptionResult signalSubscriptionResult = null;
                    return signalSubscriptionResult;
                }
                catch (UnauthorizedException ex) {
                    SignalSubscriptionResult signalSubscriptionResult;
                    block9: {
                        signalSubscriptionResult = this.unsubscribeSignal(id, self, uids);
                        if (response == null) break block9;
                        response.close();
                    }
                    return signalSubscriptionResult;
                }
            }
            SignalSubscriptionResult signalSubscriptionResult = (SignalSubscriptionResult)response.readEntity(SignalSubscriptionResult.class);
            return signalSubscriptionResult;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SignalSubscriberList getSignalSubscribers(String id, int skip, int limit) throws SymClientException {
        WebTarget builder = this.botClient.getAgentClient().target("https://" + this.botClient.getConfig().getAgentHost() + ":" + this.botClient.getConfig().getAgentPort()).path("/agent/v1/signals/{id}/subscribers".replace("{id}", id));
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        try (Response response = null;){
            response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).header("keyManagerToken", (Object)this.botClient.getSymAuth().getKmToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    SignalSubscriberList signalSubscriberList = this.getSignalSubscribers(id, skip, limit);
                    if (response != null) {
                        response.close();
                    }
                    return signalSubscriberList;
                }
                SignalSubscriberList signalSubscriberList = null;
                return signalSubscriberList;
            }
            SignalSubscriberList signalSubscriberList = (SignalSubscriberList)response.readEntity(SignalSubscriberList.class);
            return signalSubscriberList;
        }
    }
}

