/*
 * Decompiled with CFR 0.152.
 */
package clients.symphony.api;

import clients.ISymClient;
import clients.symphony.api.APIClient;
import exceptions.SymClientException;
import exceptions.UnauthorizedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.NoContentException;
import javax.ws.rs.core.Response;
import model.UserFilter;
import model.UserInfo;
import model.UserInfoList;
import model.UserSearchResult;

public class UsersClient
extends APIClient {
    private ISymClient botClient;

    public UsersClient(ISymClient client) {
        this.botClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfo getUserFromUsername(String username) throws SymClientException, NoContentException {
        try (Response response = null;){
            UserInfo info;
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/user").queryParam("username", new Object[]{username}).queryParam("local", new Object[]{true}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    UserInfo userInfo = this.getUserFromUsername(username);
                    if (response != null) {
                        response.close();
                    }
                    return userInfo;
                }
                UserInfo userInfo = null;
                return userInfo;
            }
            if (response.getStatus() == 204) {
                throw new NoContentException("No user found.");
            }
            UserInfo userInfo = info = (UserInfo)response.readEntity(UserInfo.class);
            return userInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfo getUserFromEmail(String email, Boolean local) throws SymClientException, NoContentException {
        try (Response response = null;){
            UserInfo info;
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/users").queryParam("email", new Object[]{email}).queryParam("local", new Object[]{local}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    UserInfo userInfo = this.getUserFromEmail(email, local);
                    if (response != null) {
                        response.close();
                    }
                    return userInfo;
                }
                UserInfo ex = null;
                return ex;
            }
            if (response.getStatus() == 204) {
                throw new NoContentException("No user found.");
            }
            UserInfoList infoList = (UserInfoList)response.readEntity(UserInfoList.class);
            UserInfo userInfo = info = infoList.getUsers().get(0);
            return userInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfo getUserFromId(Long id, Boolean local) throws SymClientException, NoContentException {
        try (Response response = null;){
            UserInfo info;
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/users").queryParam("uid", new Object[]{id}).queryParam("local", new Object[]{local}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    UserInfo userInfo = this.getUserFromId(id, local);
                    if (response != null) {
                        response.close();
                    }
                    return userInfo;
                }
                UserInfo ex = null;
                return ex;
            }
            if (response.getStatus() == 204) {
                throw new NoContentException("No user found.");
            }
            UserInfoList infoList = (UserInfoList)response.readEntity(UserInfoList.class);
            UserInfo userInfo = info = infoList.getUsers().get(0);
            return userInfo;
        }
    }

    public List<UserInfo> getUsersFromIdList(List<Long> idList, Boolean local) throws SymClientException, NoContentException {
        return this.getUsersV3(null, idList, local);
    }

    public List<UserInfo> getUsersFromEmailList(List<String> emailList, Boolean local) throws SymClientException, NoContentException {
        return this.getUsersV3(emailList, null, local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<UserInfo> getUsersV3(List<String> emailList, List<Long> idList, Boolean local) throws SymClientException, NoContentException {
        int i;
        List<UserInfo> infoList = new ArrayList<UserInfo>();
        boolean emailBased = false;
        StringBuilder lookUpListString = new StringBuilder();
        if (emailList != null) {
            if (emailList.isEmpty()) {
                throw new NoContentException("No user sent for lookup");
            }
            emailBased = true;
            lookUpListString.append(emailList.get(0));
            for (i = 1; i < emailList.size(); ++i) {
                lookUpListString.append("," + emailList.get(i));
            }
        } else if (idList != null) {
            if (idList.isEmpty()) {
                throw new NoContentException("No user sent for lookup");
            }
            lookUpListString.append(idList.get(0));
            for (i = 1; i < idList.size(); ++i) {
                lookUpListString.append("," + idList.get(i));
            }
        } else {
            throw new NoContentException("No user sent for lookup");
        }
        try (Response response = null;){
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v3/users").queryParam(emailBased ? "email" : "uid", new Object[]{lookUpListString.toString()}).queryParam("local", new Object[]{local}).request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    List<UserInfo> list = this.getUsersV3(emailList, idList, local);
                    if (response != null) {
                        response.close();
                    }
                    return list;
                }
                List<UserInfo> ex = null;
                return ex;
            }
            if (response.getStatus() == 204) {
                ArrayList<UserInfo> ex = infoList;
                return ex;
            }
            UserInfoList userInfo = (UserInfoList)response.readEntity(UserInfoList.class);
            List<UserInfo> list = infoList = userInfo.getUsers();
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserSearchResult searchUsers(String query, boolean local, int skip, int limit, UserFilter filter) throws SymClientException, NoContentException {
        UserSearchResult result = null;
        WebTarget builder = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v1/user/search");
        if (skip > 0) {
            builder = builder.queryParam("skip", new Object[]{skip});
        }
        if (limit > 0) {
            builder = builder.queryParam("limit", new Object[]{limit});
        }
        if (local) {
            builder = builder.queryParam("local", new Object[]{local});
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("query", query);
        body.put("filters", filter);
        try (Response response = null;){
            response = builder.request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).post(Entity.entity(body, (String)"application/json"));
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    UserSearchResult userSearchResult = this.searchUsers(query, local, skip, limit, filter);
                    if (response != null) {
                        response.close();
                    }
                    return userSearchResult;
                }
                UserSearchResult userSearchResult = null;
                return userSearchResult;
            }
            if (response.getStatus() == 204) {
                throw new NoContentException("No user found");
            }
            UserSearchResult userSearchResult = result = (UserSearchResult)response.readEntity(UserSearchResult.class);
            return userSearchResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserInfo getSessionUser() {
        try (Response response = null;){
            UserInfo info;
            response = this.botClient.getPodClient().target("https://" + this.botClient.getConfig().getPodHost() + ":" + this.botClient.getConfig().getPodPort()).path("/pod/v2/sessioninfo").request(new String[]{"application/json"}).header("sessionToken", (Object)this.botClient.getSymAuth().getSessionToken()).get();
            if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
                try {
                    this.handleError(response, this.botClient);
                }
                catch (UnauthorizedException ex) {
                    UserInfo userInfo = this.getSessionUser();
                    if (response != null) {
                        response.close();
                    }
                    return userInfo;
                }
                UserInfo userInfo = null;
                return userInfo;
            }
            UserInfo userInfo = info = (UserInfo)response.readEntity(UserInfo.class);
            return userInfo;
        }
    }
}

