/*
 * Decompiled with CFR 0.152.
 */
package services;

import clients.SymBotClient;
import clients.symphony.api.FirehoseClient;
import exceptions.SymClientException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import listeners.FirehoseListener;
import model.DatafeedEvent;
import model.events.MessageSent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirehoseService {
    private final Logger logger = LoggerFactory.getLogger(FirehoseService.class);
    private SymBotClient botClient;
    private FirehoseClient firehoseClient;
    private List<FirehoseListener> listeners;
    private String firehoseId;
    private ExecutorService pool;
    private AtomicBoolean stop = new AtomicBoolean();

    public FirehoseService(SymBotClient client) {
        this.botClient = client;
        this.listeners = new ArrayList<FirehoseListener>();
        this.firehoseClient = this.botClient.getFirehoseClient();
        this.firehoseId = this.firehoseClient.createFirehose();
        this.readFirehose();
        this.stop.set(false);
    }

    public FirehoseService(SymBotClient client, String firehoseId) {
        this.botClient = client;
        this.listeners = new ArrayList<FirehoseListener>();
        this.firehoseClient = this.botClient.getFirehoseClient();
        this.firehoseId = firehoseId;
        this.readFirehose();
        this.stop.set(false);
    }

    public void addListener(FirehoseListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(FirehoseListener listener) {
        this.listeners.remove(listener);
    }

    public void readFirehose() {
        if (this.pool != null) {
            this.pool.shutdown();
        }
        this.pool = Executors.newFixedThreadPool(5);
        CompletableFuture.supplyAsync(() -> {
            while (!this.stop.get()) {
                CompletionStage future = ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
                    try {
                        return this.firehoseClient.readFirehose(this.firehoseId);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, this.pool).exceptionally(ex -> {
                    this.handleError((Throwable)ex);
                    return null;
                })).thenApply(events -> {
                    if (events != null || !events.isEmpty()) {
                        this.handleEvents((List<DatafeedEvent>)events);
                    }
                    return null;
                });
                try {
                    ((CompletableFuture)future).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    this.logger.error("Error trying to read firehose ", (Throwable)e);
                }
            }
            return null;
        }, this.pool);
    }

    public void stopDatafeedService() {
        if (!this.stop.get()) {
            this.stop.set(true);
        }
    }

    public void restartDatafeedService() {
        if (this.stop.get()) {
            this.stop.set(false);
        }
        this.firehoseId = this.firehoseClient.createFirehose();
        this.readFirehose();
    }

    private void handleError(Throwable e) {
        this.logger.error(e.getMessage());
        try {
            TimeUnit.SECONDS.sleep(30L);
        }
        catch (InterruptedException ie) {
            this.logger.error("Error trying to sleep ", (Throwable)ie);
        }
        try {
            this.firehoseId = this.firehoseClient.createFirehose();
        }
        catch (SymClientException e1) {
            try {
                TimeUnit.SECONDS.sleep(30L);
            }
            catch (InterruptedException ie) {
                this.logger.error("Error trying to sleep ", (Throwable)ie);
            }
            this.handleError(e);
        }
    }

    private void handleEvents(List<DatafeedEvent> firehoseEvents) {
        block28: for (DatafeedEvent event : firehoseEvents) {
            if (event.getInitiator().getUser().getUserId().equals(this.botClient.getBotUserInfo().getId())) continue;
            switch (event.getType()) {
                case "MESSAGESENT": {
                    MessageSent messageSent = event.getPayload().getMessageSent();
                    if (messageSent.getMessage().getStream().getStreamType().equals("ROOM")) {
                        for (FirehoseListener listener : this.listeners) {
                            listener.onRoomMessage(messageSent.getMessage());
                        }
                        continue block28;
                    }
                    for (FirehoseListener listener : this.listeners) {
                        listener.onIMMessage(messageSent.getMessage());
                    }
                    continue block28;
                }
                case "INSTANTMESSAGECREATED": {
                    for (FirehoseListener listeners : this.listeners) {
                        listeners.onIMCreated(event.getPayload().getInstantMessageCreated().getStream());
                    }
                    continue block28;
                }
                case "ROOMCREATED": {
                    for (FirehoseListener listener : this.listeners) {
                        listener.onRoomCreated(event.getPayload().getRoomCreated());
                    }
                    continue block28;
                }
                case "ROOMUPDATED": {
                    for (FirehoseListener listener : this.listeners) {
                        listener.onRoomUpdated(event.getPayload().getRoomUpdated());
                    }
                    continue block28;
                }
                case "ROOMDEACTIVATED": {
                    for (FirehoseListener listener : this.listeners) {
                        listener.onRoomDeactivated(event.getPayload().getRoomDeactivated());
                    }
                    continue block28;
                }
                case "ROOMREACTIVATED": {
                    for (FirehoseListener listener : this.listeners) {
                        listener.onRoomReactivated(event.getPayload().getRoomReactivated().getStream());
                    }
                    continue block28;
                }
                case "USERJOINEDROOM": {
                    for (FirehoseListener listener : this.listeners) {
                        listener.onUserJoinedRoom(event.getPayload().getUserJoinedRoom());
                    }
                    continue block28;
                }
                case "USERLEFTROOM": {
                    for (FirehoseListener listener : this.listeners) {
                        listener.onUserLeftRoom(event.getPayload().getUserLeftRoom());
                    }
                    continue block28;
                }
                case "ROOMMEMBERPROMOTEDTOOWNER": {
                    for (FirehoseListener listener : this.listeners) {
                        listener.onRoomMemberPromotedToOwner(event.getPayload().getRoomMemberPromotedToOwner());
                    }
                    continue block28;
                }
                case "ROOMMEMBERDEMOTEDFROMOWNER": {
                    for (FirehoseListener listener : this.listeners) {
                        listener.onRoomMemberDemotedFromOwner(event.getPayload().getRoomMemberDemotedFromOwner());
                    }
                    continue block28;
                }
                case "CONNECTIONACCEPTED": {
                    for (FirehoseListener listener : this.listeners) {
                        listener.onConnectionAccepted(event.getPayload().getConnectionAccepted().getFromUser());
                    }
                    continue block28;
                }
                case "CONNECTIONREQUESTED": {
                    for (FirehoseListener listener : this.listeners) {
                        listener.onConnectionRequested(event.getPayload().getConnectionRequested().getToUser());
                    }
                    continue block28;
                }
            }
        }
    }
}

