/*
 * Decompiled with CFR 0.152.
 */
package utils;

import configuration.SymConfig;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.ws.rs.client.ClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientBuilderHelper {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientBuilderHelper.class);

    public static ClientBuilder getHttpClientBuilderWithTruststore(SymConfig config) {
        KeyStore jksStore = HttpClientBuilderHelper.getJksKeystore();
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        if (config.getTruststorePath() != null && jksStore != null) {
            HttpClientBuilderHelper.loadTrustStore(config, jksStore, clientBuilder);
        }
        return clientBuilder;
    }

    public static ClientBuilder getHttpClientBotBuilder(SymConfig config) {
        KeyStore pkcsStore = HttpClientBuilderHelper.getPkcsKeystore();
        KeyStore jksStore = HttpClientBuilderHelper.getJksKeystore();
        try (InputStream keyStoreIS = HttpClientBuilderHelper.loadInputStream(config.getBotCertPath() + config.getBotCertName());){
            if (pkcsStore != null) {
                pkcsStore.load(keyStoreIS, config.getBotCertPassword().toCharArray());
            }
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Error loading bot keystore file", (Throwable)e);
        }
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().keyStore(pkcsStore, config.getBotCertPassword().toCharArray());
        if (config.getTruststorePath() != null && jksStore != null) {
            HttpClientBuilderHelper.loadTrustStore(config, jksStore, clientBuilder);
        }
        return clientBuilder;
    }

    public static ClientBuilder getHttpClientAppBuilder(SymConfig config) {
        KeyStore pkcsStore = HttpClientBuilderHelper.getPkcsKeystore();
        KeyStore jksStore = HttpClientBuilderHelper.getJksKeystore();
        try (InputStream keyStoreIS = HttpClientBuilderHelper.loadInputStream(config.getAppCertPath() + config.getAppCertName());){
            if (pkcsStore != null) {
                pkcsStore.load(keyStoreIS, config.getBotCertPassword().toCharArray());
            }
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Error loading app keystore file", (Throwable)e);
        }
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().keyStore(pkcsStore, config.getAppCertPassword().toCharArray());
        if (config.getTruststorePath() != null && jksStore != null) {
            HttpClientBuilderHelper.loadTrustStore(config, jksStore, clientBuilder);
        }
        return clientBuilder;
    }

    private static void loadTrustStore(SymConfig config, KeyStore tks, ClientBuilder clientBuilder) {
        try (InputStream trustStoreIS = HttpClientBuilderHelper.loadInputStream(config.getTruststorePath());){
            tks.load(trustStoreIS, config.getTruststorePassword().toCharArray());
            clientBuilder.trustStore(tks);
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            logger.error("Error loading truststore", (Throwable)e);
        }
    }

    private static InputStream loadInputStream(String fileName) throws FileNotFoundException {
        if (new File(fileName).exists()) {
            return new FileInputStream(fileName);
        }
        if (HttpClientBuilderHelper.class.getResource(fileName) != null) {
            return HttpClientBuilderHelper.class.getResourceAsStream(fileName);
        }
        throw new FileNotFoundException();
    }

    private static KeyStore getPkcsKeystore() {
        try {
            return KeyStore.getInstance("PKCS12");
        }
        catch (KeyStoreException e) {
            logger.error("Error creating PKCS keystore instance", (Throwable)e);
            return null;
        }
    }

    private static KeyStore getJksKeystore() {
        try {
            return KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException e) {
            logger.error("Error creating JKS keystore instance", (Throwable)e);
            return null;
        }
    }
}

