/*
 * Decompiled with CFR 0.152.
 */
package utils;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Base64;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class JwtHelper {
    private static final String PEM_PRIVATE_START = "-----BEGIN PRIVATE KEY-----";
    private static final String PEM_PRIVATE_END = "-----END PRIVATE KEY-----";
    private static final String PEM_RSA_PRIVATE_START = "-----BEGIN RSA PRIVATE KEY-----";
    private static final String PEM_RSA_PRIVATE_END = "-----END RSA PRIVATE KEY-----";

    public static String createSignedJwt(String user, long expiration, Key privateKey) {
        return Jwts.builder().setSubject(user).setExpiration(new Date(System.currentTimeMillis() + expiration)).signWith(SignatureAlgorithm.RS512, privateKey).compact();
    }

    public static PrivateKey parseRSAPrivateKey(File pemPrivateKeyFile) throws IOException, GeneralSecurityException {
        return JwtHelper.parseRSAPrivateKey(FileUtils.readFileToString((File)pemPrivateKeyFile, (Charset)Charset.defaultCharset()));
    }

    private static PrivateKey parseRSAPrivateKey(String pemPrivateKey) throws GeneralSecurityException {
        if (!pemPrivateKey.contains(PEM_PRIVATE_START) && !pemPrivateKey.contains(PEM_RSA_PRIVATE_START)) {
            throw new GeneralSecurityException("Invalid private key.");
        }
        String privKeyPEM = pemPrivateKey.replace(PEM_PRIVATE_START, "").replace(PEM_PRIVATE_END, "").replace(PEM_RSA_PRIVATE_START, "").replace(PEM_RSA_PRIVATE_END, "").replaceAll("\\n", "\n").replaceAll("\\s", "");
        if (pemPrivateKey.contains(PEM_PRIVATE_START)) {
            try {
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(Base64.getDecoder().decode(privKeyPEM));
                KeyFactory kf = KeyFactory.getInstance("RSA");
                return kf.generatePrivate(spec);
            }
            catch (InvalidKeySpecException e) {
                throw new GeneralSecurityException("Invalid PKCS#8 private key.");
            }
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        PEMParser pemParser = new PEMParser((Reader)new CharArrayReader(pemPrivateKey.toCharArray()));
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        try {
            KeyPair kp = converter.getKeyPair((PEMKeyPair)pemParser.readObject());
            return kp.getPrivate();
        }
        catch (IOException e) {
            throw new GeneralSecurityException("Invalid PKCS#1 private key.");
        }
    }
}

