/*
 * Decompiled with CFR 0.152.
 */
package com.syncthemall.diffbot.api;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import com.syncthemall.diffbot.api.ArticleRequest;
import com.syncthemall.diffbot.api.FrontpageRequest;
import com.syncthemall.diffbot.api.Future;
import com.syncthemall.diffbot.api.Request;
import com.syncthemall.diffbot.exception.DiffbotAPIException;
import com.syncthemall.diffbot.exception.DiffbotIOException;
import com.syncthemall.diffbot.exception.DiffbotParseException;
import com.syncthemall.diffbot.exception.DiffbotServerException;
import com.syncthemall.diffbot.exception.DiffbotUnauthorizedException;
import com.syncthemall.diffbot.model.article.Article;
import com.syncthemall.diffbot.model.batch.BatchRequest;
import com.syncthemall.diffbot.model.batch.BatchResponse;
import com.syncthemall.diffbot.model.batch.Header;
import com.syncthemall.diffbot.model.frontpage.Frontpage;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class DiffbotAPI
implements Serializable {
    private static final long serialVersionUID = -657775976265652256L;
    protected static final String BATCH_URI = "/api/batch";
    protected static final String API_SERVER = "http://www.diffbot.com";
    protected static final String ARTICLE_URI = "/api/article";
    protected static final String FRONTPAGE_URI = "/api/frontpage";
    private String token;
    private static final String USER_AGENT = "diffbot-java-sdk/1.0";
    private static final int MAX_BATCH_REQUEST = 50;
    private static final int HTTP_OK = 200;
    private static final int HTTP_UNAUTHORIZED = 401;
    private JAXBContext jc;
    private JsonFactory jsonFactory;
    private HttpRequestFactory requestFactory;
    private List<Future> futures = new ArrayList<Future>();

    public DiffbotAPI(HttpTransport httpTransport, final JsonFactory jsonFactory, String token) throws JAXBException {
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.jsonFactory = jsonFactory;
        this.jc = JAXBContext.newInstance((Class[])new Class[]{Frontpage.class});
        this.token = token;
        this.requestFactory = httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)new JsonObjectParser(jsonFactory));
                request.getHeaders().setUserAgent(DiffbotAPI.USER_AGENT);
            }
        });
    }

    public final Article article(ArticleRequest articleRequest) throws DiffbotUnauthorizedException, DiffbotServerException, DiffbotIOException, DiffbotAPIException {
        articleRequest.set("token", this.token);
        try {
            HttpRequest request = this.requestFactory.buildGetRequest((GenericUrl)articleRequest);
            HttpResponse response = request.execute();
            if (response.getStatusCode() == 401) {
                throw new DiffbotUnauthorizedException("Not authorized API token.");
            }
            if (response.getStatusCode() != 200) {
                throw new DiffbotServerException(response.getStatusCode(), response.getStatusMessage());
            }
            Article result = (Article)response.parseAs(Article.class);
            BigDecimal errorCode = (BigDecimal)result.get("errorCode");
            if (errorCode != null) {
                throw new DiffbotAPIException(errorCode.intValue(), (String)result.get("error"));
            }
            return result;
        }
        catch (IOException e) {
            throw new DiffbotIOException(e.getMessage(), e);
        }
    }

    public final Frontpage frontpage(FrontpageRequest frontpageRequest) throws DiffbotUnauthorizedException, DiffbotServerException, DiffbotIOException, DiffbotAPIException, DiffbotParseException {
        frontpageRequest.set("token", this.token);
        try {
            HttpRequest request = this.requestFactory.buildGetRequest((GenericUrl)frontpageRequest);
            HttpResponse response = request.execute();
            if (response.getStatusCode() == 401) {
                throw new DiffbotUnauthorizedException("Not authorized API token.");
            }
            if (response.getStatusCode() != 200) {
                throw new DiffbotServerException(response.getStatusCode(), response.getStatusMessage());
            }
            if (response.getContentType() != null && !response.getContentType().isEmpty() && response.getContentType().contains("application/json")) {
                GenericJson error = (GenericJson)response.parseAs(GenericJson.class);
                BigDecimal errorCode = (BigDecimal)error.get((Object)"statusCode");
                throw new DiffbotAPIException(errorCode.intValue(), (String)error.get((Object)"message"));
            }
            return (Frontpage)this.createUnmarshaller().unmarshal(response.getContent());
        }
        catch (JAXBException e) {
            throw new DiffbotParseException("The DML response from Diffbot cannot be parsed.", e);
        }
        catch (IOException e) {
            throw new DiffbotIOException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Future<Frontpage> batch(FrontpageRequest frontpageRequest) {
        Future<Frontpage> future = new Future<Frontpage>(frontpageRequest, this);
        List<Future> list = this.futures;
        synchronized (list) {
            this.futures.add(future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Future<Article> batch(ArticleRequest articleRequest) {
        Future<Article> future = new Future<Article>(articleRequest, this);
        List<Future> list = this.futures;
        synchronized (list) {
            this.futures.add(future);
        }
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void executeBatch(Future<? extends Object> initiator) throws DiffbotUnauthorizedException, DiffbotServerException, DiffbotIOException {
        if (this.futures.contains(initiator)) {
            BatchResponse[] responses;
            ArrayList<Future> batchList = new ArrayList<Future>();
            List<Future> list = this.futures;
            synchronized (list) {
                batchList.add(initiator);
                this.futures.remove(initiator);
                int batchSize = this.futures.size() > 49 ? 49 : this.futures.size();
                List<Future> subList = this.futures.subList(0, batchSize);
                batchList.addAll(subList);
                subList.clear();
            }
            try {
                responses = this.executeBatchRequest(batchList);
            }
            catch (DiffbotIOException | DiffbotServerException | DiffbotUnauthorizedException e) {
                List<Future> list2 = this.futures;
                synchronized (list2) {
                    this.futures.addAll(batchList);
                }
                throw e;
            }
            this.parseBatchResponses(responses, batchList);
        }
    }

    private void parseBatchResponses(BatchResponse[] responses, List<Future> results) {
        int i = 0;
        while (i < responses.length) {
            String responseContent = responses[i].getBody();
            if (results.get(i).getRequest().getApiType() == Request.ApiType.ARTICLE) {
                try {
                    Article article = (Article)this.jsonFactory.createJsonParser(responseContent).parseAndClose(Article.class, null);
                    results.get(i).setResult(article).setExecuted(true);
                    BigDecimal errorCode = (BigDecimal)article.get("errorCode");
                    if (errorCode != null) {
                        throw new DiffbotAPIException(errorCode.intValue(), (String)article.get("error"));
                    }
                }
                catch (IOException e) {
                    results.get(i).setError(new DiffbotParseException("The JSON Article response from Diffbot cannot be parsed.", e)).setExecuted(true);
                }
                catch (DiffbotAPIException e) {
                    results.get(i).setError(e).setExecuted(true);
                }
            } else if (results.get(i).getRequest().getApiType() == Request.ApiType.FRONTPAGE) {
                try {
                    Header contentType = responses[i].getFirstHeader("Content-Type");
                    if (contentType != null && contentType.getValue() != null && contentType.getValue().contains("application/json")) {
                        GenericJson error = (GenericJson)this.jsonFactory.createJsonParser(responseContent).parseAndClose(GenericJson.class, null);
                        BigDecimal errorCode = (BigDecimal)error.get((Object)"statusCode");
                        throw new DiffbotAPIException(errorCode.intValue(), (String)error.get((Object)"message"));
                    }
                    Frontpage frontpage = (Frontpage)this.createUnmarshaller().unmarshal((Reader)new StringReader(responseContent));
                    results.get(i).setResult(frontpage).setExecuted(true);
                }
                catch (JAXBException e) {
                    results.get(i).setError(new DiffbotParseException("The DML Frontpage response from Diffbot cannot be parsed.", e)).setExecuted(true);
                }
                catch (IOException e) {
                    results.get(i).setError(new DiffbotParseException("The Frontpage API returned an error and the JSON error message cannot be parsed", e)).setExecuted(true);
                }
                catch (DiffbotAPIException e) {
                    results.get(i).setError(e).setExecuted(true);
                }
            }
            ++i;
        }
    }

    private BatchResponse[] executeBatchRequest(List<Future> futureRequests) throws DiffbotUnauthorizedException, DiffbotServerException, DiffbotIOException {
        ArrayList<BatchRequest> requests = new ArrayList<BatchRequest>();
        GenericUrl batchUrl = new GenericUrl("http://www.diffbot.com/api/batch").set("token", (Object)this.token);
        for (Future future : futureRequests) {
            requests.add(new BatchRequest("GET", future.getRequest().buildRelativeUrl()));
        }
        try {
            batchUrl.set("batch", (Object)this.jsonFactory.toString(requests));
            HttpRequest request = this.requestFactory.buildPostRequest(batchUrl, null);
            HttpResponse response = request.execute();
            if (response.getStatusCode() == 401) {
                throw new DiffbotUnauthorizedException("Not authorized API token.");
            }
            if (response.getStatusCode() != 200) {
                throw new DiffbotServerException(response.getStatusCode(), response.getStatusMessage());
            }
            return (BatchResponse[])response.parseAs(BatchResponse[].class);
        }
        catch (IOException e) {
            throw new DiffbotIOException(e.getMessage(), e);
        }
    }

    private Unmarshaller createUnmarshaller() {
        try {
            return this.jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Cannot instantiate a JAXB Unmarshaller. Please verify that JAXB API is in the classpath", e);
        }
    }
}

