/*
 * Decompiled with CFR 0.152.
 */
package com.syncthemall.diffbot;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonFactory;
import com.syncthemall.diffbot.Diffbot;
import com.syncthemall.diffbot.Future;
import com.syncthemall.diffbot.exception.DiffbotAPIException;
import com.syncthemall.diffbot.exception.DiffbotBatchException;
import com.syncthemall.diffbot.exception.DiffbotException;
import com.syncthemall.diffbot.exception.DiffbotParseException;
import com.syncthemall.diffbot.exception.DiffbotServerException;
import com.syncthemall.diffbot.exception.DiffbotUnauthorizedException;
import com.syncthemall.diffbot.exception.JAXBInitializationException;
import com.syncthemall.diffbot.exception.UnknownRequestAPITypeException;
import com.syncthemall.diffbot.model.Model;
import com.syncthemall.diffbot.model.article.Article;
import com.syncthemall.diffbot.model.batch.BatchRequest;
import com.syncthemall.diffbot.model.batch.BatchResponse;
import com.syncthemall.diffbot.model.classifier.Classified;
import com.syncthemall.diffbot.model.frontpage.Frontpage;
import com.syncthemall.diffbot.model.images.Images;
import com.syncthemall.diffbot.model.products.Products;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public abstract class DiffbotRequest<T extends Model> {
    private ResourceBundle bundle = ResourceBundle.getBundle("com.syncthemall.diffbot.messages.Messages");
    private HttpRequestFactory requestFactory;
    private List<Future<? extends Model>> futures;
    private JAXBContext jc;
    private JsonFactory jsonFactory;
    private Class<T> responseClass;
    private int maxBatchRequest;
    private int readTimeout = 20000;
    private int batchRequestTimeout;
    private int concurrentBatchRequest;
    private GenericUrl url;

    public DiffbotRequest(Diffbot client, Class<T> responseClass, String encodedUrl) {
        this.requestFactory = client.getRequestFactory();
        this.jc = client.getJAXBContext();
        this.jsonFactory = client.getJsonFactory();
        this.futures = client.getFutures();
        this.responseClass = responseClass;
        this.maxBatchRequest = client.getMaxBatchRequest();
        this.batchRequestTimeout = client.getBatchRequestTimeout();
        this.concurrentBatchRequest = client.getConcurrentBatchRequest();
        this.url = new GenericUrl(encodedUrl);
    }

    protected abstract ApiType getApiType();

    private String buildRelativeUrl() {
        return this.url.buildRelativeUrl();
    }

    protected final GenericUrl set(String fieldName, Object value) {
        return this.url.set(fieldName, value);
    }

    public final T execute() throws DiffbotException {
        try {
            HttpRequest request = this.requestFactory.buildGetRequest(this.url);
            request.setReadTimeout(this.readTimeout);
            HttpResponse response = request.execute();
            if (this.responseClass.equals(Frontpage.class)) {
                return this.parseFrontpage(response);
            }
            return this.parseModel(response);
        }
        catch (HttpResponseException e) {
            this.parseAPIError(e.getStatusCode(), e.getContent());
            return null;
        }
        catch (IOException e) {
            throw new DiffbotServerException(this.bundle.getString("request.not.executed"), e);
        }
    }

    private T parseFrontpage(HttpResponse response) throws DiffbotAPIException, DiffbotParseException, DiffbotServerException {
        try {
            return (T)((Object)((Model)((Object)this.createUnmarshaller().unmarshal(response.getContent()))));
        }
        catch (JAXBException e) {
            throw new DiffbotParseException(this.bundle.getString("dml.not.parsed"), e);
        }
        catch (IOException e) {
            throw new DiffbotServerException(this.bundle.getString("response.not.read"), e);
        }
    }

    private T parseModel(HttpResponse response) throws DiffbotAPIException, DiffbotParseException {
        try {
            return (T)((Object)((Model)((Object)response.parseAs(this.responseClass))));
        }
        catch (IOException e) {
            throw new DiffbotParseException(this.bundle.getString("response.not.parsed"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Future<T> queue() {
        Future future = new Future(this);
        List<Future<? extends Model>> list = this.futures;
        synchronized (list) {
            this.futures.add(future);
        }
        return future;
    }

    protected final void runBatch(Future<T> initiator) throws DiffbotBatchException {
        if (this.concurrentBatchRequest > 1) {
            this.runAsyncBatch(initiator);
        } else {
            this.runSyncBatch(initiator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSyncBatch(Future<T> initiator) throws DiffbotBatchException {
        if (this.futures.contains(initiator)) {
            ArrayList<Future<? extends Model>> batchList = new ArrayList<Future<? extends Model>>();
            List<Future<? extends Model>> list = this.futures;
            synchronized (list) {
                batchList.add(initiator);
                this.futures.remove(initiator);
                int batchSize = this.futures.size() > this.maxBatchRequest - 1 ? this.maxBatchRequest - 1 : this.futures.size();
                List<Future<? extends Model>> subList = this.futures.subList(0, batchSize);
                batchList.addAll(subList);
                subList.clear();
            }
            try {
                HttpResponse response = this.executeBatchRequest(batchList);
                BatchResponse[] responses = this.parseBatchResponse(response);
                this.parseBatchSubResponses(responses, batchList);
            }
            catch (DiffbotAPIException | DiffbotParseException | DiffbotServerException | DiffbotUnauthorizedException e) {
                List<Future<? extends Model>> list2 = this.futures;
                synchronized (list2) {
                    this.futures.addAll(batchList);
                }
                throw new DiffbotBatchException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAsyncBatch(Future<T> initiator) throws DiffbotBatchException {
        List<Future<? extends Model>> list;
        ArrayList batchCalls = new ArrayList();
        int callsToMake = 0;
        List<Future<? extends Model>> list2 = this.futures;
        synchronized (list2) {
            this.futures.remove(initiator);
            int batchSize = this.futures.size() > this.maxBatchRequest - 1 ? this.maxBatchRequest - 1 : this.futures.size();
            List<Future<? extends Model>> subList = this.futures.subList(0, batchSize);
            subList.add(initiator);
            ArrayList<Future<? extends Model>> arrayList = new ArrayList<Future<? extends Model>>();
            arrayList.addAll(subList);
            batchCalls.add(arrayList);
            ++callsToMake;
            subList.clear();
            while (!this.futures.isEmpty() && callsToMake < this.concurrentBatchRequest) {
                batchSize = this.futures.size() > this.maxBatchRequest ? this.maxBatchRequest : this.futures.size();
                subList = this.futures.subList(0, batchSize);
                ArrayList<Future<? extends Model>> arrayList2 = new ArrayList<Future<? extends Model>>();
                arrayList2.addAll(subList);
                batchCalls.add(arrayList2);
                ++callsToMake;
                subList.clear();
            }
        }
        DiffbotBatchException errorOnInitiator = null;
        HashMap<List, java.util.concurrent.Future<HttpResponse>> asyncResponses = new HashMap<List, java.util.concurrent.Future<HttpResponse>>();
        for (List list3 : batchCalls) {
            try {
                asyncResponses.put(list3, this.executeBatchAsyncRequest(list3));
            }
            catch (DiffbotParseException | DiffbotServerException e) {
                list = this.futures;
                synchronized (list) {
                    this.futures.addAll(list3);
                }
                if (!list3.contains(initiator)) continue;
                errorOnInitiator = new DiffbotBatchException(e);
            }
        }
        for (Map.Entry entry : asyncResponses.entrySet()) {
            try {
                BatchResponse[] responses = this.parseBatchResponse((HttpResponse)((java.util.concurrent.Future)entry.getValue()).get());
                this.parseBatchSubResponses(responses, (List)entry.getKey());
            }
            catch (DiffbotParseException | InterruptedException e) {
                list = this.futures;
                synchronized (list) {
                    this.futures.addAll((Collection)entry.getKey());
                }
                if (!((List)entry.getKey()).contains(initiator)) continue;
                errorOnInitiator = new DiffbotBatchException(e);
            }
            catch (ExecutionException e) {
                list = this.futures;
                synchronized (list) {
                    this.futures.addAll((Collection)entry.getKey());
                }
                if (!((List)entry.getKey()).contains(initiator)) continue;
                if (e.getCause() instanceof HttpResponseException) {
                    try {
                        this.parseAPIError(((HttpResponseException)e.getCause()).getStatusCode(), ((HttpResponseException)e.getCause()).getContent());
                    }
                    catch (DiffbotAPIException | DiffbotParseException | DiffbotUnauthorizedException e1) {
                        errorOnInitiator = new DiffbotBatchException(e1);
                    }
                    continue;
                }
                errorOnInitiator = new DiffbotBatchException(e.getCause());
            }
        }
        if (errorOnInitiator != null) {
            throw errorOnInitiator;
        }
    }

    private HttpResponse executeBatchRequest(Collection<Future<? extends Model>> futureRequests) throws DiffbotParseException, DiffbotServerException, DiffbotUnauthorizedException, DiffbotAPIException {
        try {
            HttpRequest request = this.requestFactory.buildPostRequest(this.buildBatchRequest(futureRequests), null);
            request.setReadTimeout(this.batchRequestTimeout);
            return request.execute();
        }
        catch (HttpResponseException e) {
            this.parseAPIError(e.getStatusCode(), e.getContent());
            return null;
        }
        catch (IOException e) {
            throw new DiffbotServerException(this.bundle.getString("request.not.executed"), e);
        }
    }

    private java.util.concurrent.Future<HttpResponse> executeBatchAsyncRequest(Collection<Future<? extends Model>> futureRequests) throws DiffbotParseException, DiffbotServerException {
        try {
            HttpRequest request = this.requestFactory.buildPostRequest(this.buildBatchRequest(futureRequests), null);
            request.setReadTimeout(this.batchRequestTimeout);
            return request.executeAsync();
        }
        catch (IOException e) {
            throw new DiffbotServerException(this.bundle.getString("request.not.executed"), e);
        }
    }

    private GenericUrl buildBatchRequest(Collection<Future<? extends Model>> futureRequests) throws DiffbotParseException {
        ArrayList<BatchRequest> requests = new ArrayList<BatchRequest>();
        GenericUrl batchUrl = new GenericUrl("http://www.diffbot.com/api/batch");
        for (Future<? extends Model> future : futureRequests) {
            requests.add(new BatchRequest("GET", super.buildRelativeUrl()));
        }
        batchUrl.set("batch", (Object)this.buildBatchQuery(requests));
        return batchUrl;
    }

    private String buildBatchQuery(List<BatchRequest> requests) throws DiffbotParseException {
        try {
            return this.jsonFactory.toString(requests);
        }
        catch (IOException e) {
            throw new DiffbotParseException(this.bundle.getString("batch.request.not.built"), e);
        }
    }

    private BatchResponse[] parseBatchResponse(HttpResponse response) throws DiffbotParseException {
        try {
            return (BatchResponse[])response.parseAs(BatchResponse[].class);
        }
        catch (IOException e) {
            throw new DiffbotParseException(this.bundle.getString("response.not.parsed"), e);
        }
    }

    private void parseBatchSubResponses(BatchResponse[] responses, List<Future<? extends Model>> results) {
        for (int i = 0; i < responses.length; ++i) {
            for (Future<? extends Model> future : results) {
                if (!super.buildRelativeUrl().equals(responses[i].getRelativeUrl()) || future.isExecuted()) continue;
                Future<? extends Model> result = future;
                try {
                    if (responses[i].getCode() != 200) {
                        throw new DiffbotAPIException(responses[i].getCode(), responses[i].getBody());
                    }
                    if (result.getRequest().getApiType() != ApiType.FRONTPAGE) {
                        this.parseModelBatchResponses(responses[i], result);
                        continue;
                    }
                    this.parseFrontpageBatchResponses(responses[i], result);
                }
                catch (DiffbotAPIException | DiffbotParseException e) {
                    result.setError(e);
                }
            }
        }
    }

    private void parseModelBatchResponses(BatchResponse response, Future<? extends Model> result) throws DiffbotParseException, DiffbotAPIException {
        try {
            Model model;
            if (result.getRequest().getApiType() == ApiType.ARTICLE) {
                model = (Model)((Object)this.jsonFactory.createJsonParser(response.getBody()).parseAndClose(Article.class, null));
            } else if (result.getRequest().getApiType() == ApiType.IMAGE) {
                model = (Model)((Object)this.jsonFactory.createJsonParser(response.getBody()).parseAndClose(Images.class, null));
            } else if (result.getRequest().getApiType() == ApiType.PRODUCT) {
                model = (Model)((Object)this.jsonFactory.createJsonParser(response.getBody()).parseAndClose(Products.class, null));
            } else if (result.getRequest().getApiType() == ApiType.CLASSIFIER) {
                model = (Model)((Object)this.jsonFactory.createJsonParser(response.getBody()).parseAndClose(Classified.class, null));
            } else {
                throw new UnknownRequestAPITypeException(this.bundle.getString("batch.unknow.type"), result.getRequest().getApiType());
            }
            result.setResult(model);
        }
        catch (IOException e) {
            throw new DiffbotParseException(this.bundle.getString("model.not.parsed"), e);
        }
    }

    private void parseFrontpageBatchResponses(BatchResponse response, Future<? extends Model> result) throws DiffbotAPIException, DiffbotParseException {
        try {
            Frontpage frontpage = (Frontpage)this.createUnmarshaller().unmarshal((Reader)new StringReader(response.getBody()));
            result.setResult(frontpage);
        }
        catch (JAXBException e) {
            throw new DiffbotParseException(this.bundle.getString("dml.not.parsed"), e);
        }
    }

    private Unmarshaller createUnmarshaller() {
        try {
            return this.jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new JAXBInitializationException(this.bundle.getString("jaxb.not.instanciated"), e);
        }
    }

    private void parseAPIError(int statusCode, String responseContent) throws DiffbotUnauthorizedException, DiffbotParseException, DiffbotAPIException {
        if (statusCode == 401) {
            throw new DiffbotUnauthorizedException(this.bundle.getString("token.not.authorized"));
        }
        try {
            throw new DiffbotAPIException(statusCode, ((GenericJson)this.jsonFactory.createJsonParser(responseContent).parse(GenericJson.class)).get((Object)"error").toString());
        }
        catch (IOException e) {
            throw new DiffbotParseException(this.bundle.getString("error.not.parsed"), e);
        }
    }

    protected final void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public static enum ApiType {
        ARTICLE,
        FRONTPAGE,
        IMAGE,
        PRODUCT,
        CLASSIFIER;

    }
}

