/*
 * Decompiled with CFR 0.152.
 */
package com.syncthemall.diffbot.model.classifier;

import com.google.api.client.util.Key;
import com.syncthemall.diffbot.exception.DiffbotParseException;
import com.syncthemall.diffbot.model.Model;
import com.syncthemall.diffbot.model.PageType;
import com.syncthemall.diffbot.model.article.Article;
import com.syncthemall.diffbot.model.classifier.Stats;
import com.syncthemall.diffbot.model.images.Images;
import com.syncthemall.diffbot.model.products.Products;
import java.io.IOException;
import java.io.Serializable;

public final class Classified
extends Model
implements Serializable {
    private static final long serialVersionUID = 7502076031673451491L;
    @Key
    private String title;
    @Key(value="resolved_url")
    private String resolvedUrl;
    @Key
    private String url;
    @Key(value="human_language")
    private String humanLanguage;
    @Key
    private PageType type;
    @Key
    private Stats stats;

    @Override
    public PageType getType() {
        return this.type;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return String.format("Classified [url=%s]", this.url);
    }

    public Article asArticle() throws DiffbotParseException {
        try {
            return (Article)this.getFactory().createJsonParser(super.toString()).parse(Article.class);
        }
        catch (IOException e) {
            throw new DiffbotParseException("The classified object cannot be parsed as an Article.", e);
        }
    }

    public Images asImages() throws DiffbotParseException {
        try {
            return (Images)this.getFactory().createJsonParser(super.toString()).parse(Images.class);
        }
        catch (IOException e) {
            throw new DiffbotParseException("The classified object cannot be parsed as an Images.", e);
        }
    }

    public Products asProducts() throws DiffbotParseException {
        try {
            return (Products)this.getFactory().createJsonParser(super.toString()).parse(Products.class);
        }
        catch (IOException e) {
            throw new DiffbotParseException("The classified object cannot be parsed as a Products.", e);
        }
    }

    public String getResolvedUrl() {
        return this.resolvedUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHumanLanguage() {
        return this.humanLanguage;
    }

    public Stats getStats() {
        return this.stats;
    }
}

