/*
 * Decompiled with CFR 0.152.
 */
package com.syncthemall.diffbot;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.util.ObjectParser;
import com.google.api.client.util.Preconditions;
import com.syncthemall.diffbot.DiffbotRequest;
import com.syncthemall.diffbot.Future;
import com.syncthemall.diffbot.model.Model;
import com.syncthemall.diffbot.model.PageType;
import com.syncthemall.diffbot.model.classifier.Classified;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class Diffbot {
    private ResourceBundle bundle = ResourceBundle.getBundle("com.syncthemall.diffbot.messages.Messages");
    private JAXBContext jAXBContext;
    private JsonFactory jsonFactory;
    private HttpRequestFactory requestFactory;
    private List<Future<? extends Model>> futures = new ArrayList<Future<? extends Model>>();
    private int maxBatchRequest = 25;
    private int batchRequestTimeout = 300000;
    private int concurrentBatchRequest = 1;

    public Diffbot(HttpTransport httpTransport, final JsonFactory jsonFactory, final String token) throws JAXBException {
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException(this.bundle.getString("token.empty"));
        }
        if (httpTransport == null) {
            throw new IllegalArgumentException(this.bundle.getString("transport.null"));
        }
        if (jsonFactory == null) {
            throw new IllegalArgumentException(this.bundle.getString("jsonfactory.null"));
        }
        this.jsonFactory = jsonFactory;
        this.jAXBContext = JAXBContext.newInstance((Class[])new Class[]{com.syncthemall.diffbot.model.frontpage.Frontpage.class});
        this.requestFactory = httpTransport.createRequestFactory(new HttpRequestInitializer(){

            public void initialize(HttpRequest request) {
                request.setParser((ObjectParser)new JsonObjectParser(jsonFactory));
                request.getHeaders().setUserAgent("diffbot-java-sdk/1.2.2");
                request.setInterceptor(new HttpExecuteInterceptor(){

                    public void intercept(HttpRequest request) throws IOException {
                        request.getUrl().set("token", (Object)token);
                    }
                });
            }
        });
    }

    public final JAXBContext getJAXBContext() {
        return this.jAXBContext;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public final List<Future<? extends Model>> getFutures() {
        return this.futures;
    }

    public final Frontpage frontpage() {
        return new Frontpage();
    }

    public final Article article() {
        return new Article();
    }

    public final Images images() {
        return new Images();
    }

    public final Products products() {
        return new Products();
    }

    public final Classifier classifier() {
        return new Classifier();
    }

    public final int getMaxBatchRequest() {
        return this.maxBatchRequest;
    }

    public final void setMaxBatchRequest(int maxBatchRequest) {
        if (maxBatchRequest <= 0 || maxBatchRequest > 50) {
            throw new IllegalArgumentException(this.bundle.getString("max.batch.request"));
        }
        this.maxBatchRequest = maxBatchRequest;
    }

    protected final int getBatchRequestTimeout() {
        return this.batchRequestTimeout;
    }

    public final void setBatchRequestTimeout(int batchRequestTimeout) {
        this.batchRequestTimeout = batchRequestTimeout;
    }

    protected final int getConcurrentBatchRequest() {
        return this.concurrentBatchRequest;
    }

    public final void setConcurrentBatchRequest(int concurrentBatchRequest) {
        if (this.maxBatchRequest < 1) {
            throw new IllegalArgumentException(this.bundle.getString("max.concurrent.batch"));
        }
        this.concurrentBatchRequest = concurrentBatchRequest;
    }

    public final class Classifier {
        public Analyze analyze(String url) {
            return new Analyze(url);
        }

        public class Analyze
        extends DiffbotRequest<Classified> {
            private static final String CLASSIFIER_URI = "http://api.diffbot.com/v2/analyze";

            protected Analyze(String url) {
                super(Diffbot.this, Classified.class, CLASSIFIER_URI);
                this.set("url", Preconditions.checkNotNull((Object)url, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "url")));
            }

            public final Analyze withFields(String fields) {
                this.set("fields", Preconditions.checkNotNull((Object)fields, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "fields")));
                return this;
            }

            public final Analyze withTimeout(int timeout) {
                this.set("timeout", Preconditions.checkNotNull((Object)timeout, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "timeout")));
                this.setReadTimeout(timeout);
                return this;
            }

            public final Analyze withMode(PageType type) {
                this.set("mode", Preconditions.checkNotNull((Object)type.getKey(), (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "mode")));
                return this;
            }

            public final Analyze withStats() {
                this.set("stats", "");
                return this;
            }

            @Override
            protected final DiffbotRequest.ApiType getApiType() {
                return DiffbotRequest.ApiType.CLASSIFIER;
            }
        }
    }

    public final class Products {
        public Analyze analyze(String url) {
            return new Analyze(url);
        }

        public class Analyze
        extends DiffbotRequest<com.syncthemall.diffbot.model.products.Products> {
            private static final String PRODUCT_URI = "http://api.diffbot.com/v2/product";

            protected Analyze(String url) {
                super(Diffbot.this, com.syncthemall.diffbot.model.products.Products.class, PRODUCT_URI);
                this.set("url", Preconditions.checkNotNull((Object)url, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "url")));
            }

            public final Analyze withFields(String fields) {
                this.set("fields", Preconditions.checkNotNull((Object)fields, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "fields")));
                return this;
            }

            public final Analyze withTimeout(int timeout) {
                this.set("timeout", Preconditions.checkNotNull((Object)timeout, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "timeout")));
                this.setReadTimeout(timeout);
                return this;
            }

            @Override
            protected final DiffbotRequest.ApiType getApiType() {
                return DiffbotRequest.ApiType.PRODUCT;
            }
        }
    }

    public final class Images {
        public Analyze analyze(String url) {
            return new Analyze(url);
        }

        public class Analyze
        extends DiffbotRequest<com.syncthemall.diffbot.model.images.Images> {
            private static final String IMAGE_URI = "http://api.diffbot.com/v2/image";

            protected Analyze(String url) {
                super(Diffbot.this, com.syncthemall.diffbot.model.images.Images.class, IMAGE_URI);
                this.set("url", Preconditions.checkNotNull((Object)url, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "url")));
            }

            public final Analyze withFields(String fields) {
                this.set("fields", Preconditions.checkNotNull((Object)fields, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "fields")));
                return this;
            }

            public final Analyze withTimeout(int timeout) {
                this.set("timeout", Preconditions.checkNotNull((Object)timeout, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "timeout")));
                this.setReadTimeout(timeout);
                return this;
            }

            @Override
            protected final DiffbotRequest.ApiType getApiType() {
                return DiffbotRequest.ApiType.IMAGE;
            }
        }
    }

    public final class Article {
        public Analyze analyze(String url) {
            return new Analyze(url);
        }

        public class Analyze
        extends DiffbotRequest<com.syncthemall.diffbot.model.article.Article> {
            private static final String ARTICLE_URI = "http://api.diffbot.com/v2/article";

            protected Analyze(String url) {
                super(Diffbot.this, com.syncthemall.diffbot.model.article.Article.class, ARTICLE_URI);
                this.set("url", Preconditions.checkNotNull((Object)url, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "url")));
            }

            public final Analyze withFields(String fields) {
                this.set("fields", Preconditions.checkNotNull((Object)fields, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "fields")));
                return this;
            }

            public final Analyze withTimeout(int timeout) {
                this.set("timeout", Preconditions.checkNotNull((Object)timeout, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "timeout")));
                this.setReadTimeout(timeout);
                return this;
            }

            @Override
            protected final DiffbotRequest.ApiType getApiType() {
                return DiffbotRequest.ApiType.ARTICLE;
            }
        }
    }

    public final class Frontpage {
        public Analyze analyze(String url) {
            return new Analyze(url);
        }

        public class Analyze
        extends DiffbotRequest<com.syncthemall.diffbot.model.frontpage.Frontpage> {
            private static final String FRONTPAGE_URI = "http://www.diffbot.com/api/frontpage";

            protected Analyze(String url) {
                super(Diffbot.this, com.syncthemall.diffbot.model.frontpage.Frontpage.class, FRONTPAGE_URI);
                this.set("url", Preconditions.checkNotNull((Object)url, (Object)MessageFormat.format(Diffbot.this.bundle.getString("required.parameter.null"), "url")));
                this.set("format", "xml");
            }

            @Override
            protected final DiffbotRequest.ApiType getApiType() {
                return DiffbotRequest.ApiType.FRONTPAGE;
            }
        }
    }
}

