/*
 * Decompiled with CFR 0.152.
 */
package com.syncthemall.diffbot;

import com.syncthemall.diffbot.Diffbot;
import com.syncthemall.diffbot.DiffbotRequest;
import com.syncthemall.diffbot.exception.DiffbotAPIException;
import com.syncthemall.diffbot.exception.DiffbotException;
import com.syncthemall.diffbot.exception.DiffbotParseException;
import com.syncthemall.diffbot.exception.DiffbotServerException;
import com.syncthemall.diffbot.exception.DiffbotUnauthorizedException;
import com.syncthemall.diffbot.model.Model;

public class Future<T extends Model> {
    private Diffbot client;
    private DiffbotRequest<T> request;
    private Model result;
    private DiffbotException error;
    private boolean executed = false;

    protected Future(DiffbotRequest<T> request, Diffbot client) {
        this.request = request;
        this.client = client;
    }

    protected final DiffbotRequest<T> getRequest() {
        return this.request;
    }

    protected final Future<T> setResult(Model result) {
        this.result = result;
        this.executed = true;
        return this;
    }

    protected final Future<T> setError(DiffbotException error) {
        this.error = error;
        this.executed = true;
        return this;
    }

    protected final boolean isExecuted() {
        return this.executed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final T get() throws DiffbotException {
        if (this.executed) {
            return this.getResult();
        }
        Diffbot diffbot = this.client;
        synchronized (diffbot) {
            if (!this.executed) {
                this.request.runBatch(this);
                return this.getResult();
            }
            return this.getResult();
        }
    }

    private final T getResult() throws DiffbotException {
        if (this.error != null) {
            if (this.error instanceof DiffbotAPIException) {
                throw (DiffbotAPIException)this.error;
            }
            if (this.error instanceof DiffbotParseException) {
                throw (DiffbotParseException)this.error;
            }
            if (this.error instanceof DiffbotServerException) {
                throw (DiffbotServerException)this.error;
            }
            if (this.error instanceof DiffbotUnauthorizedException) {
                throw (DiffbotUnauthorizedException)this.error;
            }
        }
        return (T)((Object)this.result);
    }
}

