/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.internal;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.taboola.backstage.internal.StringConverterFactory;
import com.taboola.backstage.internal.SynchronousCallAdapterFactory;
import com.taboola.backstage.internal.config.CommunicationConfig;
import com.taboola.backstage.internal.interceptors.CommunicationInterceptor;
import com.taboola.backstage.internal.interceptors.UserAgentInterceptor;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class CommunicationFactory {
    private final ObjectMapper objectMapper = this.createObjectMapper();
    private final Retrofit retrofit;
    private final Retrofit authRetrofit;

    public CommunicationFactory(CommunicationConfig config) {
        Retrofit.Builder retrofitBuilder = this.createRetrofitBuilder(config);
        this.authRetrofit = retrofitBuilder.baseUrl(config.getAuthenticationBaseUrl()).build();
        this.retrofit = retrofitBuilder.baseUrl(config.getBackstageBaseUrl()).build();
    }

    private ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return objectMapper;
    }

    private HttpLoggingInterceptor createLoggingInterceptor(CommunicationConfig config) {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new CommunicationInterceptor());
        if (config.isDebug()) {
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
        } else {
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
        }
        return loggingInterceptor;
    }

    private Retrofit.Builder createRetrofitBuilder(CommunicationConfig config) {
        return new Retrofit.Builder().addConverterFactory((Converter.Factory)StringConverterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.objectMapper)).addCallAdapterFactory((CallAdapter.Factory)SynchronousCallAdapterFactory.create(this.objectMapper)).client(this.createOkHttpClient(config));
    }

    private OkHttpClient createOkHttpClient(CommunicationConfig config) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)this.createLoggingInterceptor(config)).addInterceptor((Interceptor)new UserAgentInterceptor(config.getUserAgent())).readTimeout(config.getReadTimeoutMillis(), TimeUnit.MILLISECONDS).writeTimeout(config.getWriteTimeoutMillis(), TimeUnit.MILLISECONDS).connectTimeout(config.getConnectionTimeoutMillis(), TimeUnit.MILLISECONDS).build();
    }

    public <E> E createRetrofitAuthEndpoint(Class<E> clazz) {
        return (E)this.authRetrofit.create(clazz);
    }

    public <E> E createRetrofitEndpoint(Class<E> clazz) {
        return (E)this.retrofit.create(clazz);
    }
}

