/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.model.media.campaigns;

import com.taboola.backstage.annotations.Final;
import com.taboola.backstage.annotations.ReadOnly;
import com.taboola.backstage.annotations.Required;
import com.taboola.backstage.model.media.campaigns.CampaignApprovalState;
import com.taboola.backstage.model.media.campaigns.CampaignStatus;
import com.taboola.backstage.model.media.campaigns.CampaignTargeting;
import com.taboola.backstage.model.media.campaigns.DailyAdDeliveryModel;
import com.taboola.backstage.model.media.campaigns.PublisherBidModifier;
import com.taboola.backstage.model.media.campaigns.SpendingLimitModel;
import com.taboola.backstage.model.media.campaigns.TrafficAllocationMode;
import java.util.Date;
import java.util.Objects;

public class Campaign {
    @ReadOnly
    protected String id;
    @ReadOnly
    protected String advertiserId;
    @Required
    protected String name;
    @Required
    protected String brandingText;
    protected String trackingCode;
    @Required
    protected Double cpc;
    protected Double dailyCap;
    protected DailyAdDeliveryModel dailyAdDeliveryModel;
    protected PublisherBidModifier publisherBidModifier;
    protected TrafficAllocationMode trafficAllocationMode;
    @Required
    protected Double spendingLimit;
    @Required
    protected SpendingLimitModel spendingLimitModel;
    protected CampaignTargeting countryTargeting;
    protected CampaignTargeting subCountryTargeting;
    protected CampaignTargeting platformTargeting;
    protected CampaignTargeting publisherTargeting;
    @ReadOnly
    protected CampaignTargeting postalCodeTargeting;
    protected String comments;
    @Final
    protected Date startDate;
    protected Date endDate;
    @ReadOnly
    protected CampaignApprovalState approvalState;
    protected Boolean isActive;
    @ReadOnly
    protected Double spent;
    @ReadOnly
    protected CampaignStatus status;

    public String getId() {
        return this.id;
    }

    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public String getName() {
        return this.name;
    }

    public String getBrandingText() {
        return this.brandingText;
    }

    public String getTrackingCode() {
        return this.trackingCode;
    }

    public Double getCpc() {
        return this.cpc;
    }

    public Double getDailyCap() {
        return this.dailyCap;
    }

    public DailyAdDeliveryModel getDailyAdDeliveryModel() {
        return this.dailyAdDeliveryModel;
    }

    public PublisherBidModifier getPublisherBidModifier() {
        return this.publisherBidModifier;
    }

    public Double getSpendingLimit() {
        return this.spendingLimit;
    }

    public SpendingLimitModel getSpendingLimitModel() {
        return this.spendingLimitModel;
    }

    public CampaignTargeting getCountryTargeting() {
        return this.countryTargeting;
    }

    public CampaignTargeting getSubCountryTargeting() {
        return this.subCountryTargeting;
    }

    public CampaignTargeting getPlatformTargeting() {
        return this.platformTargeting;
    }

    public CampaignTargeting getPublisherTargeting() {
        return this.publisherTargeting;
    }

    public CampaignTargeting getPostalCodeTargeting() {
        return this.postalCodeTargeting;
    }

    public String getComments() {
        return this.comments;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public CampaignApprovalState getApprovalState() {
        return this.approvalState;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public Double getSpent() {
        return this.spent;
    }

    public CampaignStatus getStatus() {
        return this.status;
    }

    public TrafficAllocationMode getTrafficAllocationMode() {
        return this.trafficAllocationMode;
    }

    public String toString() {
        return "Campaign{id=" + this.id + ", advertiserId='" + this.advertiserId + '\'' + ", name='" + this.name + '\'' + ", brandingText='" + this.brandingText + '\'' + ", trackingCode='" + this.trackingCode + '\'' + ", cpc=" + this.cpc + ", dailyCap=" + this.dailyCap + ", dailyAdDeliveryModel='" + (Object)((Object)this.dailyAdDeliveryModel) + '\'' + ", publisherBidModifier=" + this.publisherBidModifier + ", spendingLimit=" + this.spendingLimit + ", spendingLimitModel='" + (Object)((Object)this.spendingLimitModel) + '\'' + ", countryTargeting=" + this.countryTargeting + ", subCountryTargeting=" + this.subCountryTargeting + ", platformTargeting=" + this.platformTargeting + ", publisherTargeting=" + this.publisherTargeting + ", postalCodeTargeting=" + this.postalCodeTargeting + ", comments='" + this.comments + '\'' + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", approvalState='" + (Object)((Object)this.approvalState) + '\'' + ", isActive=" + this.isActive + ", spent=" + this.spent + ", status='" + (Object)((Object)this.status) + '\'' + ", trafficAllocationMode='" + (Object)((Object)this.trafficAllocationMode) + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Campaign campaign = (Campaign)o;
        return Objects.equals(this.id, campaign.id) && Objects.equals(this.advertiserId, campaign.advertiserId) && Objects.equals(this.name, campaign.name) && Objects.equals(this.brandingText, campaign.brandingText) && Objects.equals(this.trackingCode, campaign.trackingCode) && Objects.equals(this.cpc, campaign.cpc) && Objects.equals(this.dailyCap, campaign.dailyCap) && Objects.equals((Object)this.dailyAdDeliveryModel, (Object)campaign.dailyAdDeliveryModel) && Objects.equals(this.publisherBidModifier, campaign.publisherBidModifier) && Objects.equals(this.spendingLimit, campaign.spendingLimit) && Objects.equals((Object)this.spendingLimitModel, (Object)campaign.spendingLimitModel) && Objects.equals(this.countryTargeting, campaign.countryTargeting) && Objects.equals(this.subCountryTargeting, campaign.subCountryTargeting) && Objects.equals(this.platformTargeting, campaign.platformTargeting) && Objects.equals(this.publisherTargeting, campaign.publisherTargeting) && Objects.equals(this.postalCodeTargeting, campaign.postalCodeTargeting) && Objects.equals(this.comments, campaign.comments) && Objects.equals(this.startDate, campaign.startDate) && Objects.equals(this.endDate, campaign.endDate) && Objects.equals((Object)this.approvalState, (Object)campaign.approvalState) && Objects.equals(this.isActive, campaign.isActive) && Objects.equals(this.spent, campaign.spent) && Objects.equals((Object)this.trafficAllocationMode, (Object)campaign.trafficAllocationMode) && Objects.equals((Object)this.status, (Object)campaign.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.advertiserId, this.name, this.brandingText, this.trackingCode, this.cpc, this.dailyCap, this.dailyAdDeliveryModel, this.publisherBidModifier, this.spendingLimit, this.spendingLimitModel, this.countryTargeting, this.subCountryTargeting, this.platformTargeting, this.publisherTargeting, this.postalCodeTargeting, this.comments, this.startDate, this.endDate, this.approvalState, this.isActive, this.spent, this.status, this.trafficAllocationMode});
    }
}

