/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.services;

import com.taboola.backstage.exceptions.BackstageAPIConnectivityException;
import com.taboola.backstage.exceptions.BackstageAPIRequestException;
import com.taboola.backstage.exceptions.BackstageAPIUnauthorizedException;
import com.taboola.backstage.internal.BackstageAuthenticationEndpoint;
import com.taboola.backstage.model.auth.AuthenticationDetails;
import com.taboola.backstage.model.auth.BackstageAuthentication;
import com.taboola.backstage.model.auth.ClientCredentialAuthenticationDetails;
import com.taboola.backstage.model.auth.GrantType;
import com.taboola.backstage.model.auth.PasswordAuthenticationDetails;
import com.taboola.backstage.model.auth.Token;
import com.taboola.backstage.model.auth.TokenDetails;
import com.taboola.backstage.services.AuthenticationService;
import java.util.Objects;

public class AuthenticationServiceImpl
implements AuthenticationService {
    private final BackstageAuthenticationEndpoint endpoint;

    public AuthenticationServiceImpl(BackstageAuthenticationEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public BackstageAuthentication clientCredentials(String clientId, String clientSecret) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        ClientCredentialAuthenticationDetails details = new ClientCredentialAuthenticationDetails(clientId, clientSecret);
        return new BackstageAuthentication(details, this.endpoint.getAuthToken(clientId, clientSecret, details.getGrantType().getValue()));
    }

    @Override
    public BackstageAuthentication passwordAuthentication(String clientId, String clientSecret, String username, String password) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        PasswordAuthenticationDetails details = new PasswordAuthenticationDetails(clientId, clientSecret, username, password);
        return new BackstageAuthentication(details, this.endpoint.getAuthToken(clientId, clientSecret, username, password, details.getGrantType().getValue()));
    }

    @Override
    public BackstageAuthentication reAuthenticate(BackstageAuthentication auth) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        AuthenticationDetails details = auth.getDetails();
        if (details == null) {
            throw new IllegalStateException("Can't reAuthenticate without authentication details");
        }
        GrantType grantType = details.getGrantType();
        if (grantType == null) {
            throw new IllegalStateException("Unknown grant type");
        }
        switch (grantType) {
            case CLIENT_CREDENTIALS: {
                if (details instanceof ClientCredentialAuthenticationDetails) {
                    ClientCredentialAuthenticationDetails clientCredentialDetails = (ClientCredentialAuthenticationDetails)details;
                    return this.clientCredentials(clientCredentialDetails.getClientId(), clientCredentialDetails.getClientSecret());
                }
                throw new IllegalStateException("Invalid BackstageAuthentication instance, expected to be ClientCredentialAuthenticationDetails");
            }
            case PASSWORD_AUTHENTICATION: {
                if (details instanceof PasswordAuthenticationDetails) {
                    PasswordAuthenticationDetails passwordAuthDetails = (PasswordAuthenticationDetails)details;
                    return this.passwordAuthentication(passwordAuthDetails.getClientId(), passwordAuthDetails.getClientSecret(), passwordAuthDetails.getUsername(), passwordAuthDetails.getPassword());
                }
                throw new IllegalStateException("Invalid BackstageAuthentication instance, expected to be PasswordAuthenticationDetails");
            }
        }
        throw new IllegalStateException("Unknown grant type");
    }

    @Override
    public BackstageAuthentication authenticate(String accessToken) {
        Objects.requireNonNull(accessToken, "accessToken");
        Token token = new Token();
        token.setAccessToken(accessToken);
        return new BackstageAuthentication(null, token);
    }

    @Override
    public TokenDetails getTokenDetails(BackstageAuthentication auth) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        return this.endpoint.getTokenDetails(auth.getToken().getAccessTokenForHeader());
    }
}

