/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage;

import com.taboola.backstage.internal.BackstageAccountEndpoint;
import com.taboola.backstage.internal.BackstageAudienceTargetingEndpoint;
import com.taboola.backstage.internal.BackstageAuthenticationEndpoint;
import com.taboola.backstage.internal.BackstageCampaignItemsEndpoint;
import com.taboola.backstage.internal.BackstageCampaignsEndpoint;
import com.taboola.backstage.internal.BackstageDictionaryEndpoint;
import com.taboola.backstage.internal.BackstageInternalTools;
import com.taboola.backstage.internal.BackstageInternalToolsImpl;
import com.taboola.backstage.internal.BackstageMediaReportsEndpoint;
import com.taboola.backstage.internal.BackstagePostalTargetingEndpoint;
import com.taboola.backstage.internal.BackstagePublisherReportsEndpoint;
import com.taboola.backstage.internal.CommunicationFactory;
import com.taboola.backstage.internal.config.CommunicationConfig;
import com.taboola.backstage.internal.config.SerializationConfig;
import com.taboola.backstage.internal.config.UserAgentHeader;
import com.taboola.backstage.internal.factories.BackstageEndpointsRetrofitFactory;
import com.taboola.backstage.model.RequestHeader;
import com.taboola.backstage.services.AccountsService;
import com.taboola.backstage.services.AccountsServiceImpl;
import com.taboola.backstage.services.AdvertiserReportsService;
import com.taboola.backstage.services.AuthenticationService;
import com.taboola.backstage.services.AuthenticationServiceImpl;
import com.taboola.backstage.services.CampaignAudienceTargetingService;
import com.taboola.backstage.services.CampaignAudienceTargetingServiceImpl;
import com.taboola.backstage.services.CampaignItemsService;
import com.taboola.backstage.services.CampaignItemsServiceImpl;
import com.taboola.backstage.services.CampaignPostalTargetingService;
import com.taboola.backstage.services.CampaignPostalTargetingServiceImpl;
import com.taboola.backstage.services.CampaignsService;
import com.taboola.backstage.services.CampaignsServiceImpl;
import com.taboola.backstage.services.DictionaryService;
import com.taboola.backstage.services.DictionaryServiceImpl;
import com.taboola.backstage.services.PublisherReportsService;
import com.taboola.backstage.services.ReportsService;
import com.taboola.backstage.services.ReportsServiceImpl;
import com.taboola.backstage.services.UserService;
import com.taboola.backstage.services.UserServiceImpl;
import java.util.ArrayList;
import java.util.Collection;

public class Backstage {
    private final CampaignsService campaignsService;
    private final AuthenticationService authenticationService;
    private final UserService userService;
    private final CampaignItemsService campaignItemsService;
    private final DictionaryService dictionaryService;
    private final ReportsService reportsService;
    private final AccountsService accountsService;
    private final CampaignPostalTargetingService campaignPostalCodeTargetingService;
    private final BackstageInternalTools internalTools;
    private final CampaignAudienceTargetingService campaignAudienceTargetingService;

    private Backstage(BackstageInternalTools internalTools, CampaignsService campaignsService, AuthenticationService authenticationService, UserService userService, CampaignItemsService campaignItemsService, DictionaryService dictionaryService, ReportsService reportsService, AccountsService accountsService, CampaignPostalTargetingService campaignPostalCodeTargetingService, CampaignAudienceTargetingService campaignAudienceTargetingService) {
        this.internalTools = internalTools;
        this.campaignsService = campaignsService;
        this.authenticationService = authenticationService;
        this.userService = userService;
        this.campaignItemsService = campaignItemsService;
        this.dictionaryService = dictionaryService;
        this.reportsService = reportsService;
        this.accountsService = accountsService;
        this.campaignPostalCodeTargetingService = campaignPostalCodeTargetingService;
        this.campaignAudienceTargetingService = campaignAudienceTargetingService;
    }

    public static BackstageBuilder builder() {
        return new BackstageBuilder();
    }

    public CampaignsService campaignsService() {
        return this.campaignsService;
    }

    public AuthenticationService authenticationService() {
        return this.authenticationService;
    }

    public UserService userService() {
        return this.userService;
    }

    public CampaignItemsService campaignItemsService() {
        return this.campaignItemsService;
    }

    public DictionaryService dictionaryService() {
        return this.dictionaryService;
    }

    public ReportsService reportsService() {
        return this.reportsService;
    }

    public AdvertiserReportsService advertiserReportsService() {
        return this.reportsService;
    }

    public PublisherReportsService publisherReportsService() {
        return this.reportsService;
    }

    public AccountsService accountsService() {
        return this.accountsService;
    }

    public CampaignPostalTargetingService campaignPostalCodeTargetingService() {
        return this.campaignPostalCodeTargetingService;
    }

    public CampaignAudienceTargetingService campaignAudienceTargetingService() {
        return this.campaignAudienceTargetingService;
    }

    public BackstageInternalTools internalTools() {
        return this.internalTools;
    }

    public static class BackstageBuilder {
        private static final String DEFAULT_BACKSTAGE_HOST = "https://backstage.taboola.com/backstage/";
        private static final String DEFAULT_AUTH_BACKSTAGE_HOST = "https://authentication.taboola.com/authentication/";
        private static final String DEFAULT_USER_AGENT = "Taboola Java Client";
        private static final String VERSION = "1.0.22";
        private static final Integer DEFAULT_MAX_IDLE_CONNECTIONS = 5;
        private static final Long DEFAULT_KEEP_ALIVE_DURATION_MILLIS = 300000L;
        private static final SerializationConfig DEFAULT_SERIALIZATION_CONFIG = new SerializationConfig();
        private String baseUrl;
        private String authBaseUrl;
        private String userAgent;
        private Long writeTimeoutMillis;
        private Long connectionTimeoutMillis;
        private Long readTimeoutMillis;
        private Integer maxIdleConnections;
        private Long keepAliveDurationMillis;
        private Boolean performClientValidations;
        private Boolean debug;
        private Boolean organizeDynamicColumns;
        private SerializationConfig serializationConfig;
        private Collection<RequestHeader> headers;

        public BackstageBuilder setBaseUrl(String baseUrl) {
            this.baseUrl = baseUrl;
            return this;
        }

        public BackstageBuilder setAuthBaseUrl(String authBaseUrl) {
            this.authBaseUrl = authBaseUrl;
            return this;
        }

        public BackstageBuilder setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public BackstageBuilder setConnectionTimeoutMillis(Long connectionTimeoutMillis) {
            this.connectionTimeoutMillis = connectionTimeoutMillis;
            return this;
        }

        public BackstageBuilder setReadTimeoutMillis(Long readTimeoutMillis) {
            this.readTimeoutMillis = readTimeoutMillis;
            return this;
        }

        public BackstageBuilder setWriteTimeoutMillis(Long writeTimeoutMillis) {
            this.writeTimeoutMillis = writeTimeoutMillis;
            return this;
        }

        public BackstageBuilder setMaxIdleConnections(Integer maxIdleConnections) {
            this.maxIdleConnections = maxIdleConnections;
            return this;
        }

        public BackstageBuilder setKeepAliveDurationMillis(Long keepAliveDurationMillis) {
            this.keepAliveDurationMillis = keepAliveDurationMillis;
            return this;
        }

        public BackstageBuilder setPerformClientValidations(Boolean performClientValidations) {
            this.performClientValidations = performClientValidations;
            return this;
        }

        public BackstageBuilder setDebug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public BackstageBuilder setOrganizeDynamicColumns(Boolean organizeDynamicColumns) {
            this.organizeDynamicColumns = organizeDynamicColumns;
            return this;
        }

        public BackstageBuilder setSerializationConfig(SerializationConfig serializationConfig) {
            this.serializationConfig = serializationConfig;
            return this;
        }

        public BackstageBuilder setHeaders(Collection<RequestHeader> headers) {
            this.headers = headers;
            return this;
        }

        public Backstage build() {
            this.organizeState();
            String finalUserAgent = String.format("Backstage/%s (%s)", VERSION, this.userAgent);
            Collection<RequestHeader> headers = this.getAllHeaders(this.headers, finalUserAgent);
            CommunicationConfig config = new CommunicationConfig(this.baseUrl, this.authBaseUrl, this.connectionTimeoutMillis, this.readTimeoutMillis, this.writeTimeoutMillis, this.maxIdleConnections, this.keepAliveDurationMillis, headers, this.debug);
            CommunicationFactory communicator = new CommunicationFactory(config, this.serializationConfig);
            BackstageEndpointsRetrofitFactory endpointsFactory = new BackstageEndpointsRetrofitFactory(communicator);
            BackstageInternalToolsImpl internalTools = new BackstageInternalToolsImpl(endpointsFactory);
            return new Backstage(internalTools, new CampaignsServiceImpl(this.performClientValidations, endpointsFactory.createEndpoint(BackstageCampaignsEndpoint.class)), new AuthenticationServiceImpl(endpointsFactory.createAuthEndpoint(BackstageAuthenticationEndpoint.class)), new UserServiceImpl(endpointsFactory.createEndpoint(BackstageAccountEndpoint.class)), new CampaignItemsServiceImpl(this.performClientValidations, endpointsFactory.createEndpoint(BackstageCampaignItemsEndpoint.class)), new DictionaryServiceImpl(endpointsFactory.createEndpoint(BackstageDictionaryEndpoint.class)), new ReportsServiceImpl(endpointsFactory.createEndpoint(BackstageMediaReportsEndpoint.class), endpointsFactory.createEndpoint(BackstagePublisherReportsEndpoint.class), internalTools, this.organizeDynamicColumns), new AccountsServiceImpl(endpointsFactory.createEndpoint(BackstageAccountEndpoint.class)), new CampaignPostalTargetingServiceImpl(this.performClientValidations, endpointsFactory.createEndpoint(BackstagePostalTargetingEndpoint.class)), new CampaignAudienceTargetingServiceImpl(this.performClientValidations, endpointsFactory.createEndpoint(BackstageAudienceTargetingEndpoint.class)));
        }

        private Collection<RequestHeader> getAllHeaders(Collection<RequestHeader> clientHeaders, String finalUserAgent) {
            ArrayList<RequestHeader> headers = new ArrayList<RequestHeader>();
            if (clientHeaders != null) {
                headers.addAll(clientHeaders);
            }
            headers.add(new UserAgentHeader(finalUserAgent));
            return headers;
        }

        private void organizeState() {
            if (this.baseUrl == null) {
                this.baseUrl = DEFAULT_BACKSTAGE_HOST;
            }
            if (this.authBaseUrl == null) {
                this.authBaseUrl = DEFAULT_AUTH_BACKSTAGE_HOST;
            }
            if (this.connectionTimeoutMillis == null) {
                this.connectionTimeoutMillis = 0L;
            }
            if (this.readTimeoutMillis == null) {
                this.readTimeoutMillis = 0L;
            }
            if (this.writeTimeoutMillis == null) {
                this.writeTimeoutMillis = 0L;
            }
            if (this.maxIdleConnections == null) {
                this.maxIdleConnections = DEFAULT_MAX_IDLE_CONNECTIONS;
            }
            if (this.keepAliveDurationMillis == null) {
                this.keepAliveDurationMillis = DEFAULT_KEEP_ALIVE_DURATION_MILLIS;
            }
            if (this.userAgent == null) {
                this.userAgent = DEFAULT_USER_AGENT;
            }
            if (this.performClientValidations == null) {
                this.performClientValidations = true;
            }
            if (this.debug == null) {
                this.debug = false;
            }
            if (this.organizeDynamicColumns == null) {
                this.organizeDynamicColumns = true;
            }
            if (this.serializationConfig == null) {
                this.serializationConfig = DEFAULT_SERIALIZATION_CONFIG;
            }
        }
    }
}

