/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.internal;

import com.taboola.backstage.exceptions.BackstageAPIException;
import com.taboola.backstage.model.Results;
import com.taboola.backstage.model.media.campaigns.Campaign;
import com.taboola.backstage.model.media.campaigns.CampaignPatch;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface BackstageCampaignsEndpoint {
    @POST(value="api/1.0/{account_id}/campaigns")
    @Headers(value={"Content-Type: application/json"})
    public Campaign createCampaign(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Body Campaign var3) throws BackstageAPIException;

    @GET(value="api/1.0/{account_id}/campaigns")
    @Headers(value={"Content-Type: application/json"})
    public Results<Campaign> getAllCampaigns(@Header(value="Authorization") String var1, @Path(value="account_id") String var2) throws BackstageAPIException;

    @GET(value="api/1.0/{account_id}/campaigns/{campaign_id}")
    @Headers(value={"Content-Type: application/json"})
    public Campaign getCampaign(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Path(value="campaign_id") String var3) throws BackstageAPIException;

    @POST(value="api/1.0/{account_id}/campaigns/{campaign_id}")
    @Headers(value={"Content-Type: application/json"})
    public Campaign updateCampaign(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Path(value="campaign_id") String var3, @Body Campaign var4) throws BackstageAPIException;

    @POST(value="api/1.0/{account_id}/campaigns/{campaign_id}/duplicate")
    @Headers(value={"Content-Type: application/json"})
    public Campaign duplicateCampaign(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Path(value="campaign_id") String var3) throws BackstageAPIException;

    @POST(value="api/1.0/{account_id}/campaigns/{campaign_id}/duplicate")
    @Headers(value={"Content-Type: application/json"})
    public Campaign duplicateCampaign(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Path(value="campaign_id") String var3, @Body Campaign var4) throws BackstageAPIException;

    @PATCH(value="api/1.0/{account_id}/campaigns/{campaign_id}")
    @Headers(value={"Content-Type: application/json"})
    public CampaignPatch patchCampaign(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Path(value="campaign_id") String var3, @Body CampaignPatch var4) throws BackstageAPIException;

    @DELETE(value="api/1.0/{account_id}/campaigns/{campaign_id}")
    @Headers(value={"Content-Type: application/json"})
    public Campaign deleteCampaign(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Path(value="campaign_id") String var3);
}

