/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.internal;

import com.taboola.backstage.exceptions.BackstageAPIException;
import com.taboola.backstage.model.Results;
import com.taboola.backstage.model.dictionary.Resource;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;

public interface BackstageDictionaryEndpoint {
    @GET(value="api/1.0/resources/{dictionary_suffix}")
    @Headers(value={"Content-Type: application/json"})
    public String custom(@Header(value="Authorization") String var1, @Path(value="dictionary_suffix", encoded=true) String var2) throws BackstageAPIException;

    @GET(value="api/1.0/resources")
    @Headers(value={"Content-Type: application/json"})
    public Results<Resource> getRoot(@Header(value="Authorization") String var1) throws BackstageAPIException;

    @GET(value="api/1.0/resources/countries")
    @Headers(value={"Content-Type: application/json"})
    public Results<Resource> getCountries(@Header(value="Authorization") String var1) throws BackstageAPIException;

    @GET(value="api/1.0/resources/countries/{country_code}/regions")
    @Headers(value={"Content-Type: application/json"})
    public Results<Resource> getSpecificCountryRegions(@Header(value="Authorization") String var1, @Path(value="country_code") String var2) throws BackstageAPIException;

    @GET(value="api/1.0/resources/countries/{country_code}/postal")
    @Headers(value={"Content-Type: application/json"})
    public Results<Resource> getSpecificCountryPostals(@Header(value="Authorization") String var1, @Path(value="country_code") String var2) throws BackstageAPIException;

    @GET(value="api/1.0/resources/countries/US/dma")
    @Headers(value={"Content-Type: application/json"})
    public Results<Resource> getUnitedStatesDMA(@Header(value="Authorization") String var1) throws BackstageAPIException;

    @GET(value="api/1.0/resources/countries/{country_code}/cities")
    @Headers(value={"Content-Type: application/json"})
    public Results<Resource> getSpecificCountryCities(@Header(value="Authorization") String var1, @Path(value="country_code") String var2) throws BackstageAPIException;

    @GET(value="api/1.0/resources/platforms")
    @Headers(value={"Content-Type: application/json"})
    public Results<Resource> getPlatforms(@Header(value="Authorization") String var1) throws BackstageAPIException;

    @GET(value="api/1.0/resources/campaigns_properties/operating_systems")
    @Headers(value={"Content-Type: application/json"})
    public Results<Resource> getOperationSystem(@Header(value="Authorization") String var1) throws BackstageAPIException;

    @GET(value="api/1.0/resources/campaigns_properties/operating_systems/{operation_system}")
    @Headers(value={"Content-Type: application/json"})
    public Results<Resource> getOperationSystemSubCategories(@Header(value="Authorization") String var1, @Path(value="operation_system") String var2) throws BackstageAPIException;
}

