/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.taboola.backstage.internal.StringConverterFactory;
import com.taboola.backstage.internal.SynchronousCallAdapterFactory;
import com.taboola.backstage.internal.config.CommunicationConfig;
import com.taboola.backstage.internal.config.SerializationConfig;
import com.taboola.backstage.internal.interceptors.CommunicationInterceptor;
import com.taboola.backstage.internal.interceptors.HeadersInterceptor;
import com.taboola.backstage.internal.serialization.SerializationMapperCreator;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class CommunicationFactory {
    private final ObjectMapper objectMapper;
    private final Retrofit retrofit;
    private final Retrofit authRetrofit;

    public CommunicationFactory(CommunicationConfig communicationConfig, SerializationConfig serializationConfig) {
        this.objectMapper = SerializationMapperCreator.createObjectMapper(serializationConfig);
        Retrofit.Builder retrofitBuilder = this.createRetrofitBuilder(communicationConfig);
        this.authRetrofit = retrofitBuilder.baseUrl(communicationConfig.getAuthenticationBaseUrl()).build();
        this.retrofit = retrofitBuilder.baseUrl(communicationConfig.getBackstageBaseUrl()).build();
    }

    private HttpLoggingInterceptor createLoggingInterceptor(CommunicationConfig config) {
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor((HttpLoggingInterceptor.Logger)new CommunicationInterceptor());
        if (config.isDebug()) {
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            loggingInterceptor.redactHeader("Authorization");
            loggingInterceptor.redactHeader("Cookie");
        } else {
            loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
        }
        return loggingInterceptor;
    }

    private Retrofit.Builder createRetrofitBuilder(CommunicationConfig config) {
        return new Retrofit.Builder().addConverterFactory((Converter.Factory)StringConverterFactory.create()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)this.objectMapper)).addCallAdapterFactory((CallAdapter.Factory)SynchronousCallAdapterFactory.create(this.objectMapper)).client(this.createOkHttpClient(config));
    }

    private OkHttpClient createOkHttpClient(CommunicationConfig config) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new HeadersInterceptor(config.getHeaders())).addInterceptor((Interceptor)this.createLoggingInterceptor(config)).readTimeout(config.getReadTimeoutMillis(), TimeUnit.MILLISECONDS).writeTimeout(config.getWriteTimeoutMillis(), TimeUnit.MILLISECONDS).connectTimeout(config.getConnectionTimeoutMillis(), TimeUnit.MILLISECONDS).connectionPool(new ConnectionPool(config.getMaxIdleConnections(), config.getKeepAliveDurationMillis(), TimeUnit.MILLISECONDS)).build();
    }

    public <E> E createRetrofitAuthEndpoint(Class<E> clazz) {
        return (E)this.authRetrofit.create(clazz);
    }

    public <E> E createRetrofitEndpoint(Class<E> clazz) {
        return (E)this.retrofit.create(clazz);
    }
}

