/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.taboola.backstage.exceptions.BackstageAPIConnectivityException;
import com.taboola.backstage.exceptions.BackstageAPIRequestException;
import com.taboola.backstage.exceptions.BackstageAPIUnauthorizedException;
import com.taboola.backstage.model.APIError;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import okhttp3.ResponseBody;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

public class SynchronousCallAdapterFactory
extends CallAdapter.Factory {
    private static final Logger logger = LogManager.getLogger(SynchronousCallAdapterFactory.class);
    private static final int UNAUTHORIZED_HTTP_STATUS_CODE = 401;
    private static final int BAD_REQUEST_HTTP_STATUS_CODE = 400;
    private static final int INTERNAL_SERVER_ERROR_HTTP_STATUS_CODE = 500;
    private final ObjectMapper objectMapper;

    public static SynchronousCallAdapterFactory create(ObjectMapper objectMapper) {
        return new SynchronousCallAdapterFactory(objectMapper);
    }

    private SynchronousCallAdapterFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public CallAdapter<Object, Object> get(final Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (returnType instanceof Call || returnType.toString().contains("retrofit2.Call")) {
            return null;
        }
        return new CallAdapter<Object, Object>(){

            public Type responseType() {
                return returnType;
            }

            public Object adapt(Call<Object> call) {
                Object obj;
                try {
                    Response response = call.execute();
                    if (!response.isSuccessful()) {
                        int responseCode = response.code();
                        if (responseCode == 401) {
                            throw new BackstageAPIUnauthorizedException(SynchronousCallAdapterFactory.this.safeCreateCauseException((Response<Object>)response));
                        }
                        if (responseCode >= 400 && responseCode < 500) {
                            throw new BackstageAPIRequestException(responseCode, SynchronousCallAdapterFactory.this.normalizeError(SynchronousCallAdapterFactory.this.parseError(response)));
                        }
                        throw new BackstageAPIConnectivityException(SynchronousCallAdapterFactory.this.safeCreateCauseException((Response<Object>)response), responseCode);
                    }
                    obj = response.body();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                    throw new BackstageAPIConnectivityException(e);
                }
                return obj;
            }
        };
    }

    private IOException safeCreateCauseException(Response<Object> response) {
        try {
            return new IOException(response.errorBody().string());
        }
        catch (Throwable t) {
            logger.warn("Failed to parse API error response", t);
            return new IOException("Failed to parse API error response", t);
        }
    }

    private APIError parseError(Response errorResponse) {
        ResponseBody errorBody = errorResponse.errorBody();
        try {
            return (APIError)this.objectMapper.readValue(errorBody.bytes(), APIError.class);
        }
        catch (Throwable e) {
            logger.warn("Failed to parse API error response object [{}]", (Object)errorResponse.message());
            return new APIError(errorResponse.message(), errorResponse.code());
        }
    }

    APIError normalizeError(APIError error) {
        String message = error.getMessage();
        if (message != null) {
            error.setMessage(message.replaceAll("%", "%%"));
        }
        return error;
    }
}

