/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.services;

import com.taboola.backstage.exceptions.BackstageAPIConnectivityException;
import com.taboola.backstage.exceptions.BackstageAPIRequestException;
import com.taboola.backstage.exceptions.BackstageAPIUnauthorizedException;
import com.taboola.backstage.internal.BackstageAudienceTargetingEndpoint;
import com.taboola.backstage.internal.FieldsValidator;
import com.taboola.backstage.model.auth.BackstageAuthentication;
import com.taboola.backstage.model.media.campaigns.CampaignLookalikeAudienceTargeting;
import com.taboola.backstage.model.media.campaigns.CampaignMultiTargetingCollection;
import com.taboola.backstage.services.CampaignAudienceTargetingService;

public class CampaignAudienceTargetingServiceImpl
implements CampaignAudienceTargetingService {
    private final Boolean performClientValidations;
    private final BackstageAudienceTargetingEndpoint endpoint;

    public CampaignAudienceTargetingServiceImpl(Boolean performClientValidations, BackstageAudienceTargetingEndpoint endpoint) {
        this.endpoint = endpoint;
        this.performClientValidations = performClientValidations;
    }

    @Override
    public CampaignMultiTargetingCollection<Long> readAudienceSegments(BackstageAuthentication auth, String accountId, String campaignId) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        return this.endpoint.readAudienceSegments(auth.getToken().getAccessTokenForHeader(), accountId, campaignId);
    }

    @Override
    public CampaignMultiTargetingCollection<Long> updateAudienceSegments(BackstageAuthentication auth, String accountId, String campaignId, CampaignMultiTargetingCollection<Long> targeting) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        if (this.performClientValidations.booleanValue()) {
            FieldsValidator.validateCreateOperation(targeting);
        }
        return this.endpoint.updateAudienceSegments(auth.getToken().getAccessTokenForHeader(), accountId, campaignId, targeting);
    }

    @Override
    public CampaignMultiTargetingCollection<Long> readCustomAudience(BackstageAuthentication auth, String accountId, String campaignId) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        return this.endpoint.readCustomAudience(auth.getToken().getAccessTokenForHeader(), accountId, campaignId);
    }

    @Override
    public CampaignMultiTargetingCollection<Long> updateCustomAudience(BackstageAuthentication auth, String accountId, String campaignId, CampaignMultiTargetingCollection<Long> targeting) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        if (this.performClientValidations.booleanValue()) {
            FieldsValidator.validateCreateOperation(targeting);
        }
        return this.endpoint.updateCustomAudience(auth.getToken().getAccessTokenForHeader(), accountId, campaignId, targeting);
    }

    @Override
    public CampaignMultiTargetingCollection<CampaignLookalikeAudienceTargeting> readLookalikeAudience(BackstageAuthentication auth, String accountId, String campaignId) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        return this.endpoint.readLookalikeAudience(auth.getToken().getAccessTokenForHeader(), accountId, campaignId);
    }

    @Override
    public CampaignMultiTargetingCollection<CampaignLookalikeAudienceTargeting> updateLookalikeAudience(BackstageAuthentication auth, String accountId, String campaignId, CampaignMultiTargetingCollection<CampaignLookalikeAudienceTargeting> targeting) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        if (this.performClientValidations.booleanValue()) {
            FieldsValidator.validateCreateOperation(targeting);
        }
        return this.endpoint.updateLookalikeAudience(auth.getToken().getAccessTokenForHeader(), accountId, campaignId, targeting);
    }

    @Override
    public CampaignMultiTargetingCollection<String> readMarkingLabels(BackstageAuthentication auth, String accountId, String campaignId) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        return this.endpoint.readMarkingLabels(auth.getToken().getAccessTokenForHeader(), accountId, campaignId);
    }

    @Override
    public CampaignMultiTargetingCollection<String> updateMarkingLabels(BackstageAuthentication auth, String accountId, String campaignId, CampaignMultiTargetingCollection<String> targeting) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        if (this.performClientValidations.booleanValue()) {
            FieldsValidator.validateCreateOperation(targeting);
        }
        return this.endpoint.updateMarkingLabels(auth.getToken().getAccessTokenForHeader(), accountId, campaignId, targeting);
    }
}

