/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.services;

import com.taboola.backstage.exceptions.BackstageAPIConnectivityException;
import com.taboola.backstage.exceptions.BackstageAPIRequestException;
import com.taboola.backstage.exceptions.BackstageAPIUnauthorizedException;
import com.taboola.backstage.internal.BackstagePostalTargetingEndpoint;
import com.taboola.backstage.internal.FieldsValidator;
import com.taboola.backstage.model.auth.BackstageAuthentication;
import com.taboola.backstage.model.media.campaigns.targeting.PostalTargeting;
import com.taboola.backstage.services.CampaignPostalTargetingService;

public class CampaignPostalTargetingServiceImpl
implements CampaignPostalTargetingService {
    private final BackstagePostalTargetingEndpoint endpoint;
    private final Boolean performClientValidations;

    public CampaignPostalTargetingServiceImpl(Boolean performClientValidations, BackstagePostalTargetingEndpoint endpoint) {
        this.endpoint = endpoint;
        this.performClientValidations = performClientValidations;
    }

    @Override
    public PostalTargeting read(BackstageAuthentication auth, String accountId, String campaignId) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessTokenForHeader = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.read(accessTokenForHeader, accountId, campaignId);
    }

    @Override
    public PostalTargeting update(BackstageAuthentication auth, String accountId, String campaignId, PostalTargeting targeting) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        if (this.performClientValidations.booleanValue()) {
            FieldsValidator.validateCreateOperation(targeting);
        }
        String accessTokenForHeader = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.update(accessTokenForHeader, accountId, campaignId, targeting);
    }
}

