/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.services;

import com.taboola.backstage.exceptions.BackstageAPIConnectivityException;
import com.taboola.backstage.exceptions.BackstageAPIRequestException;
import com.taboola.backstage.exceptions.BackstageAPIUnauthorizedException;
import com.taboola.backstage.internal.BackstageInternalTools;
import com.taboola.backstage.internal.BackstageMediaReportsEndpoint;
import com.taboola.backstage.internal.BackstagePublisherReportsEndpoint;
import com.taboola.backstage.model.ReportFilter;
import com.taboola.backstage.model.auth.BackstageAuthentication;
import com.taboola.backstage.model.media.reports.CampaignSummaryDimensions;
import com.taboola.backstage.model.media.reports.CampaignSummaryOptionalFilters;
import com.taboola.backstage.model.media.reports.CampaignSummaryReport;
import com.taboola.backstage.model.media.reports.TopCampaignContentOptionalFilters;
import com.taboola.backstage.model.media.reports.TopCampaignContentReport;
import com.taboola.backstage.model.publishers.reports.RecirculationSummaryDimensions;
import com.taboola.backstage.model.publishers.reports.RecirculationSummaryOptionalFilters;
import com.taboola.backstage.model.publishers.reports.RecirculationSummaryReport;
import com.taboola.backstage.model.publishers.reports.RevenueSummaryDimensions;
import com.taboola.backstage.model.publishers.reports.RevenueSummaryOptionalFilters;
import com.taboola.backstage.model.publishers.reports.RevenueSummaryReport;
import com.taboola.backstage.model.publishers.reports.VisitValueDimensions;
import com.taboola.backstage.model.publishers.reports.VisitValueOptionalFilters;
import com.taboola.backstage.model.publishers.reports.VisitValueReport;
import com.taboola.backstage.services.ReportsService;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

public class ReportsServiceImpl
implements ReportsService {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ISO_LOCAL_DATE;
    private final BackstageMediaReportsEndpoint mediaReportsEndpoint;
    private final BackstagePublisherReportsEndpoint publisherReportsService;
    private final BackstageInternalTools backstageInternalTools;
    private final Boolean organizeDynamicColumns;

    public ReportsServiceImpl(BackstageMediaReportsEndpoint mediaReportsEndpoint, BackstagePublisherReportsEndpoint publisherReportsService, BackstageInternalTools backstageInternalTools, Boolean organizeDynamicColumns) {
        this.mediaReportsEndpoint = mediaReportsEndpoint;
        this.publisherReportsService = publisherReportsService;
        this.backstageInternalTools = backstageInternalTools;
        this.organizeDynamicColumns = organizeDynamicColumns;
    }

    @Override
    public TopCampaignContentReport getTopCampaignContentReport(BackstageAuthentication auth, String accountId, LocalDate startDate, LocalDate endDate) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        return this.getTopCampaignContentReport(auth, accountId, startDate, endDate, Collections.emptyMap());
    }

    @Override
    public TopCampaignContentReport getTopCampaignContentReport(BackstageAuthentication auth, String accountId, LocalDate startDate, LocalDate endDate, Map<TopCampaignContentOptionalFilters, String> filters) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        TopCampaignContentReport report = this.mediaReportsEndpoint.getTopCampaignContentReport(accessToken, accountId, DATE_TIME_FORMATTER.format(startDate), DATE_TIME_FORMATTER.format(endDate), this.formatOptionalFilters(filters));
        if (this.organizeDynamicColumns.booleanValue()) {
            this.backstageInternalTools.attachDynamicFieldMetadataToFields(report);
        }
        return report;
    }

    @Override
    public CampaignSummaryReport getCampaignSummaryReport(BackstageAuthentication auth, String accountId, LocalDate startDate, LocalDate endDate, CampaignSummaryDimensions dimension) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        return this.getCampaignSummaryReport(auth, accountId, startDate, endDate, dimension, Collections.emptyMap());
    }

    @Override
    public CampaignSummaryReport getCampaignSummaryReport(BackstageAuthentication auth, String accountId, LocalDate startDate, LocalDate endDate, CampaignSummaryDimensions dimension, Map<CampaignSummaryOptionalFilters, String> filters) {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        CampaignSummaryReport report = this.mediaReportsEndpoint.getCampaignSummary(accessToken, accountId, dimension.getName(), DATE_TIME_FORMATTER.format(startDate), DATE_TIME_FORMATTER.format(endDate), this.formatOptionalFilters(filters));
        if (this.organizeDynamicColumns.booleanValue()) {
            this.backstageInternalTools.attachDynamicFieldMetadataToFields(report);
        }
        return report;
    }

    private <T extends ReportFilter> Map<String, String> formatOptionalFilters(Map<T, String> filters) {
        return filters.entrySet().stream().collect(Collectors.toMap(e -> ((ReportFilter)e.getKey()).getName(), Map.Entry::getValue));
    }

    @Override
    public RevenueSummaryReport getRevenueSummaryReport(BackstageAuthentication auth, String accountId, LocalDate startDate, LocalDate endDate, RevenueSummaryDimensions dimension) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        return this.getRevenueSummaryReport(auth, accountId, startDate, endDate, dimension, Collections.emptyMap());
    }

    @Override
    public RevenueSummaryReport getRevenueSummaryReport(BackstageAuthentication auth, String accountId, LocalDate startDate, LocalDate endDate, RevenueSummaryDimensions dimension, Map<RevenueSummaryOptionalFilters, String> filters) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.publisherReportsService.getRevenueSummary(accessToken, accountId, dimension.getName(), DATE_TIME_FORMATTER.format(startDate), DATE_TIME_FORMATTER.format(endDate), this.formatOptionalFilters(filters));
    }

    @Override
    public VisitValueReport getVisitValueReport(BackstageAuthentication auth, String accountId, LocalDate startDate, LocalDate endDate, VisitValueDimensions dimension) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        return this.getVisitValueReport(auth, accountId, startDate, endDate, dimension, Collections.emptyMap());
    }

    @Override
    public VisitValueReport getVisitValueReport(BackstageAuthentication auth, String accountId, LocalDate startDate, LocalDate endDate, VisitValueDimensions dimension, Map<VisitValueOptionalFilters, String> filters) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.publisherReportsService.getVisitValue(accessToken, accountId, dimension.getName(), DATE_TIME_FORMATTER.format(startDate), DATE_TIME_FORMATTER.format(endDate), this.formatOptionalFilters(filters));
    }

    @Override
    public RecirculationSummaryReport getRecirculationSummaryReport(BackstageAuthentication auth, String accountId, LocalDate startDate, LocalDate endDate, RecirculationSummaryDimensions dimension) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        return this.getRecirculationSummaryReport(auth, accountId, startDate, endDate, dimension, Collections.emptyMap());
    }

    @Override
    public RecirculationSummaryReport getRecirculationSummaryReport(BackstageAuthentication auth, String accountId, LocalDate startDate, LocalDate endDate, RecirculationSummaryDimensions dimension, Map<RecirculationSummaryOptionalFilters, String> filters) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.publisherReportsService.getRecirculationSummary(accessToken, accountId, dimension.getName(), DATE_TIME_FORMATTER.format(startDate), DATE_TIME_FORMATTER.format(endDate), this.formatOptionalFilters(filters));
    }
}

