/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.exceptions;

import com.taboola.backstage.model.APIError;

public abstract class BackstageAPIException
extends RuntimeException {
    private APIError error = APIError.EMPTY;

    public BackstageAPIException(String message, Object ... params) {
        super(String.format(message, params));
    }

    public BackstageAPIException(APIError error, String message, Object ... params) {
        super(String.format(message + BackstageAPIException.parseError(error), params));
        this.error = error;
    }

    public BackstageAPIException(APIError error, String message, Throwable t, Object ... params) {
        super(String.format(message + BackstageAPIException.parseError(error), params), t);
        this.error = error;
    }

    private static String parseError(APIError error) {
        if (error == null || APIError.EMPTY.equals(error)) {
            return "";
        }
        return String.format(". Response payload status [%s], message [%s]", error.getHttpStatus(), error.getMessage());
    }

    public APIError getError() {
        return this.error;
    }
}

