/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.model.media.campaigns;

import com.taboola.backstage.annotations.Final;
import com.taboola.backstage.annotations.ReadOnly;
import com.taboola.backstage.annotations.Required;
import com.taboola.backstage.model.media.campaigns.BidType;
import com.taboola.backstage.model.media.campaigns.CampaignApprovalState;
import com.taboola.backstage.model.media.campaigns.CampaignStatus;
import com.taboola.backstage.model.media.campaigns.CampaignTargeting;
import com.taboola.backstage.model.media.campaigns.DailyAdDeliveryModel;
import com.taboola.backstage.model.media.campaigns.MarketingObjective;
import com.taboola.backstage.model.media.campaigns.OperationSystem;
import com.taboola.backstage.model.media.campaigns.PublisherBidModifier;
import com.taboola.backstage.model.media.campaigns.SpendingLimitModel;
import com.taboola.backstage.model.media.campaigns.TrafficAllocationMode;
import com.taboola.backstage.model.media.campaigns.scheduling.ActivitySchedule;
import java.util.Date;
import java.util.Objects;

public class Campaign {
    @ReadOnly
    protected String id;
    @ReadOnly
    protected String advertiserId;
    @Required
    protected String name;
    @Required
    protected String brandingText;
    protected String trackingCode;
    @Required
    protected Double cpc;
    protected Double dailyCap;
    protected DailyAdDeliveryModel dailyAdDeliveryModel;
    protected PublisherBidModifier publisherBidModifier;
    protected TrafficAllocationMode trafficAllocationMode;
    @Required
    protected Double spendingLimit;
    @Required
    protected SpendingLimitModel spendingLimitModel;
    protected CampaignTargeting<String> countryTargeting;
    protected CampaignTargeting<String> subCountryTargeting;
    protected CampaignTargeting<String> platformTargeting;
    protected CampaignTargeting<String> publisherTargeting;
    protected CampaignTargeting<OperationSystem> osTargeting;
    @ReadOnly
    protected CampaignTargeting<String> postalCodeTargeting;
    protected String comments;
    protected BidType bidType;
    protected MarketingObjective marketingObjective;
    protected ActivitySchedule activitySchedule;
    @Final
    protected Date startDate;
    protected Date endDate;
    @ReadOnly
    protected CampaignApprovalState approvalState;
    protected Boolean isActive;
    @ReadOnly
    protected Double spent;
    @ReadOnly
    protected CampaignStatus status;

    public String getId() {
        return this.id;
    }

    public String getAdvertiserId() {
        return this.advertiserId;
    }

    public String getName() {
        return this.name;
    }

    public String getBrandingText() {
        return this.brandingText;
    }

    public String getTrackingCode() {
        return this.trackingCode;
    }

    public Double getCpc() {
        return this.cpc;
    }

    public Double getDailyCap() {
        return this.dailyCap;
    }

    public DailyAdDeliveryModel getDailyAdDeliveryModel() {
        return this.dailyAdDeliveryModel;
    }

    public PublisherBidModifier getPublisherBidModifier() {
        return this.publisherBidModifier;
    }

    public Double getSpendingLimit() {
        return this.spendingLimit;
    }

    public SpendingLimitModel getSpendingLimitModel() {
        return this.spendingLimitModel;
    }

    public CampaignTargeting<String> getCountryTargeting() {
        return this.countryTargeting;
    }

    public CampaignTargeting<String> getSubCountryTargeting() {
        return this.subCountryTargeting;
    }

    public CampaignTargeting<String> getPlatformTargeting() {
        return this.platformTargeting;
    }

    public CampaignTargeting<String> getPublisherTargeting() {
        return this.publisherTargeting;
    }

    public CampaignTargeting<String> getPostalCodeTargeting() {
        return this.postalCodeTargeting;
    }

    public CampaignTargeting<OperationSystem> getOsTargeting() {
        return this.osTargeting;
    }

    public String getComments() {
        return this.comments;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public CampaignApprovalState getApprovalState() {
        return this.approvalState;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public Double getSpent() {
        return this.spent;
    }

    public CampaignStatus getStatus() {
        return this.status;
    }

    public TrafficAllocationMode getTrafficAllocationMode() {
        return this.trafficAllocationMode;
    }

    public BidType getBidType() {
        return this.bidType;
    }

    public MarketingObjective getMarketingObjective() {
        return this.marketingObjective;
    }

    public ActivitySchedule getActivitySchedule() {
        return this.activitySchedule;
    }

    public String toString() {
        return "Campaign{id='" + this.id + '\'' + ", advertiserId='" + this.advertiserId + '\'' + ", name='" + this.name + '\'' + ", brandingText='" + this.brandingText + '\'' + ", trackingCode='" + this.trackingCode + '\'' + ", cpc=" + this.cpc + ", dailyCap=" + this.dailyCap + ", dailyAdDeliveryModel=" + (Object)((Object)this.dailyAdDeliveryModel) + ", publisherBidModifier=" + this.publisherBidModifier + ", trafficAllocationMode=" + (Object)((Object)this.trafficAllocationMode) + ", spendingLimit=" + this.spendingLimit + ", spendingLimitModel=" + (Object)((Object)this.spendingLimitModel) + ", countryTargeting=" + this.countryTargeting + ", subCountryTargeting=" + this.subCountryTargeting + ", platformTargeting=" + this.platformTargeting + ", publisherTargeting=" + this.publisherTargeting + ", osTargeting=" + this.osTargeting + ", postalCodeTargeting=" + this.postalCodeTargeting + ", comments='" + this.comments + '\'' + ", bidType=" + (Object)((Object)this.bidType) + ", marketingObjective=" + (Object)((Object)this.marketingObjective) + ", activitySchedule=" + this.activitySchedule + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", approvalState=" + (Object)((Object)this.approvalState) + ", isActive=" + this.isActive + ", spent=" + this.spent + ", status=" + (Object)((Object)this.status) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Campaign campaign = (Campaign)o;
        return Objects.equals(this.id, campaign.id) && Objects.equals(this.advertiserId, campaign.advertiserId) && Objects.equals(this.name, campaign.name) && Objects.equals(this.brandingText, campaign.brandingText) && Objects.equals(this.trackingCode, campaign.trackingCode) && Objects.equals(this.cpc, campaign.cpc) && Objects.equals(this.dailyCap, campaign.dailyCap) && this.dailyAdDeliveryModel == campaign.dailyAdDeliveryModel && Objects.equals(this.publisherBidModifier, campaign.publisherBidModifier) && this.trafficAllocationMode == campaign.trafficAllocationMode && Objects.equals(this.spendingLimit, campaign.spendingLimit) && this.spendingLimitModel == campaign.spendingLimitModel && Objects.equals(this.countryTargeting, campaign.countryTargeting) && Objects.equals(this.subCountryTargeting, campaign.subCountryTargeting) && Objects.equals(this.platformTargeting, campaign.platformTargeting) && Objects.equals(this.publisherTargeting, campaign.publisherTargeting) && Objects.equals(this.osTargeting, campaign.osTargeting) && Objects.equals(this.postalCodeTargeting, campaign.postalCodeTargeting) && Objects.equals(this.comments, campaign.comments) && this.bidType == campaign.bidType && this.marketingObjective == campaign.marketingObjective && Objects.equals(this.activitySchedule, campaign.activitySchedule) && Objects.equals(this.startDate, campaign.startDate) && Objects.equals(this.endDate, campaign.endDate) && this.approvalState == campaign.approvalState && Objects.equals(this.isActive, campaign.isActive) && Objects.equals(this.spent, campaign.spent) && this.status == campaign.status;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.advertiserId, this.name, this.brandingText, this.trackingCode, this.cpc, this.dailyCap, this.dailyAdDeliveryModel, this.publisherBidModifier, this.trafficAllocationMode, this.spendingLimit, this.spendingLimitModel, this.countryTargeting, this.subCountryTargeting, this.platformTargeting, this.publisherTargeting, this.osTargeting, this.postalCodeTargeting, this.comments, this.bidType, this.marketingObjective, this.activitySchedule, this.startDate, this.endDate, this.approvalState, this.isActive, this.spent, this.status});
    }
}

