/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.services;

import com.taboola.backstage.exceptions.BackstageAPIConnectivityException;
import com.taboola.backstage.exceptions.BackstageAPIRequestException;
import com.taboola.backstage.exceptions.BackstageAPIUnauthorizedException;
import com.taboola.backstage.internal.BackstageDictionaryEndpoint;
import com.taboola.backstage.model.Results;
import com.taboola.backstage.model.auth.BackstageAuthentication;
import com.taboola.backstage.model.dictionary.Resource;
import com.taboola.backstage.services.DictionaryService;

public class DictionaryServiceImpl
implements DictionaryService {
    private final BackstageDictionaryEndpoint endpoint;

    public DictionaryServiceImpl(BackstageDictionaryEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public String custom(BackstageAuthentication auth, String ... resourceName) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.custom(accessToken, String.join((CharSequence)"/", resourceName));
    }

    @Override
    public Results<Resource> getRoot(BackstageAuthentication auth) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.getRoot(accessToken);
    }

    @Override
    public Results<Resource> getCountries(BackstageAuthentication auth) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.getCountries(accessToken);
    }

    @Override
    public Results<Resource> getSpecificCountryRegions(BackstageAuthentication auth, String countryCode) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.getSpecificCountryRegions(accessToken, countryCode);
    }

    @Override
    public Results<Resource> getSpecificCountryPostals(BackstageAuthentication auth, String countryCode) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.getSpecificCountryPostals(accessToken, countryCode);
    }

    @Override
    public Results<Resource> getUnitedStatesDMA(BackstageAuthentication auth) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.getUnitedStatesDMA(accessToken);
    }

    @Override
    public Results<Resource> getPlatforms(BackstageAuthentication auth) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.getPlatforms(accessToken);
    }

    @Override
    public Results<Resource> getOperationSystem(BackstageAuthentication auth) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.getOperationSystem(accessToken);
    }

    @Override
    public Results<Resource> getOperationSystemSubCategories(BackstageAuthentication auth, String operationSystem) throws BackstageAPIUnauthorizedException, BackstageAPIConnectivityException, BackstageAPIRequestException {
        String accessToken = auth.getToken().getAccessTokenForHeader();
        return this.endpoint.getOperationSystemSubCategories(accessToken, operationSystem);
    }
}

