/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.internal;

import com.taboola.backstage.exceptions.BackstageAPIException;
import com.taboola.backstage.model.Account;
import com.taboola.backstage.model.Results;
import com.taboola.backstage.model.dictionary.AudienceSegment;
import com.taboola.backstage.model.dictionary.LookalikeAudience;
import com.taboola.backstage.model.media.account.AccountBlockedPublishers;
import com.taboola.backstage.model.media.account.AccountBlockedPublishersPatch;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.Path;

public interface BackstageAccountEndpoint {
    @GET(value="api/1.0/users/current/allowed-accounts")
    @Headers(value={"Content-Type: application/json"})
    public Results<Account> getUserAllowedAccounts(@Header(value="Authorization") String var1) throws BackstageAPIException;

    @GET(value="api/1.0/users/current/account")
    @Headers(value={"Content-Type: application/json"})
    public Account getUserAccount(@Header(value="Authorization") String var1) throws BackstageAPIException;

    @GET(value="api/1.0/taboola-network/publishers")
    @Headers(value={"Content-Type: application/json"})
    public Results<Account> getAvailablePublishersUnderTaboolaNetwork(@Header(value="Authorization") String var1) throws BackstageAPIException;

    @GET(value="api/1.0/{account_id}/dictionary/audience_segments")
    @Headers(value={"Content-Type: application/json"})
    public Results<AudienceSegment> getAllAudienceSegments(@Header(value="Authorization") String var1, @Path(value="account_id") String var2) throws BackstageAPIException;

    @GET(value="api/1.0/{account_id}/dictionary/audience_segments/{country_code}")
    @Headers(value={"Content-Type: application/json"})
    public Results<AudienceSegment> getSpecificCountryAudienceSegments(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Path(value="country_code") String var3) throws BackstageAPIException;

    @GET(value="api/1.0/{account_id}/dictionary/lookalike_audiences")
    @Headers(value={"Content-Type: application/json"})
    public Results<LookalikeAudience> getLookalikeAudiences(@Header(value="Authorization") String var1, @Path(value="account_id") String var2) throws BackstageAPIException;

    @GET(value="api/1.0/{account_id}/dictionary/lookalike_audiences/{country_code}")
    @Headers(value={"Content-Type: application/json"})
    public Results<LookalikeAudience> getSpecificCountryLookalikeAudiences(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Path(value="country_code") String var3) throws BackstageAPIException;

    @GET(value="api/1.0/{account_id}/block-publisher")
    @Headers(value={"Content-Type: application/json"})
    public AccountBlockedPublishers getAccountBlockedPublishers(@Header(value="Authorization") String var1, @Path(value="account_id") String var2) throws BackstageAPIException;

    @POST(value="api/1.0/{account_id}/block-publisher")
    @Headers(value={"Content-Type: application/json"})
    public AccountBlockedPublishers createAccountBlockedPublishers(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Body AccountBlockedPublishers var3) throws BackstageAPIException;

    @PATCH(value="api/1.0/{account_id}/block-publisher")
    @Headers(value={"Content-Type: application/json"})
    public AccountBlockedPublishersPatch patchAccountBlockedPublishers(@Header(value="Authorization") String var1, @Path(value="account_id") String var2, @Body AccountBlockedPublishersPatch var3) throws BackstageAPIException;
}

