/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.internal.factories;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.taboola.backstage.exceptions.BackstageAPIConnectivityException;
import com.taboola.backstage.exceptions.BackstageAPIRequestException;
import com.taboola.backstage.exceptions.BackstageAPIUnauthorizedException;
import com.taboola.backstage.model.APIError;
import com.taboola.rest.api.exceptions.factories.ExceptionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackstageAPIExceptionFactory
implements ExceptionFactory {
    private static final Logger logger = LogManager.getLogger(BackstageAPIExceptionFactory.class);
    private final ObjectMapper objectMapper;

    public BackstageAPIExceptionFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public RuntimeException createUnauthorizedException(Throwable cause) {
        return new BackstageAPIUnauthorizedException(cause);
    }

    public RuntimeException createRequestException(int responseCode, byte[] errorBytes, String message) {
        return new BackstageAPIRequestException(responseCode, this.normalizeError(this.parseError(responseCode, errorBytes, message)));
    }

    private APIError parseError(int responseCode, byte[] errorBytes, String message) {
        try {
            return (APIError)this.objectMapper.readValue(errorBytes, APIError.class);
        }
        catch (Throwable e) {
            logger.warn("Failed to parse API error response object [{}]", (Object)message);
            return new APIError(message, responseCode);
        }
    }

    APIError normalizeError(APIError error) {
        String message = error.getMessage();
        if (message != null) {
            error.setMessage(message.replaceAll("%", "%%"));
        }
        return error;
    }

    public RuntimeException createConnectivityException(Throwable cause, int responseCode) {
        return new BackstageAPIConnectivityException(cause, responseCode);
    }

    public RuntimeException createConnectivityException(Throwable cause) {
        return new BackstageAPIConnectivityException(cause);
    }
}

