/*
 * Decompiled with CFR 0.152.
 */
package com.taboola.backstage.model.auth;

import java.util.Objects;

public class Token {
    private static final int MILLISECONDS_IN_SINGLE_SECOND = 1000;
    private String accessToken;
    private String refreshToken;
    private String tokenType;
    private Integer expiresIn;
    private final Long creationTimestamp = System.currentTimeMillis();

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getAccessTokenForHeader() {
        return "Bearer " + this.getAccessToken();
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public void setExpiresIn(Integer expiresIn) {
        this.expiresIn = expiresIn;
    }

    public boolean isExpired() {
        Objects.requireNonNull(this.expiresIn, "Expires in is null");
        return System.currentTimeMillis() >= this.creationTimestamp + (long)(this.expiresIn * 1000);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Token token = (Token)o;
        return Objects.equals(this.accessToken, token.accessToken) && Objects.equals(this.refreshToken, token.refreshToken) && Objects.equals(this.tokenType, token.tokenType) && Objects.equals(this.creationTimestamp, token.creationTimestamp) && Objects.equals(this.expiresIn, token.expiresIn);
    }

    public int hashCode() {
        return Objects.hash(this.accessToken, this.refreshToken, this.tokenType, this.expiresIn, this.creationTimestamp);
    }

    public String toString() {
        return "Token{accessToken='" + this.accessToken + '\'' + ", refreshToken='" + this.refreshToken + '\'' + ", tokenType='" + this.tokenType + '\'' + ", expiresIn=" + this.expiresIn + ", creationTimestamp=" + this.creationTimestamp + '}';
    }
}

