/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin;

import com.tagmycode.sdk.exception.TagMyCodeJsonException;
import com.tagmycode.sdk.model.LanguageCollection;
import com.tagmycode.sdk.model.User;
import java.util.Date;
import org.json.JSONException;

public abstract class AbstractPreferences {
    private final String LANGUAGES = "languages";
    private final String PRIVATE_SNIPPET = "private_snippet";
    private final String LAST_LANGUAGE = "last_language";
    private final String ACCOUNT = "account";
    private final String LAST_UPDATE = "last_update";

    protected abstract String read(String var1);

    protected abstract void write(String var1, String var2);

    protected abstract void unset(String var1);

    public User getAccount() throws TagMyCodeJsonException {
        String jsonAccount = this.read("account");
        if (jsonAccount == null) {
            throw new TagMyCodeJsonException();
        }
        return new User(jsonAccount);
    }

    public void setAccount(User user) throws JSONException {
        this.write("account", user.toJson());
    }

    public LanguageCollection getLanguageCollection() throws TagMyCodeJsonException {
        String jsonLanguages = this.read("languages");
        if (jsonLanguages == null) {
            throw new TagMyCodeJsonException();
        }
        return new LanguageCollection(jsonLanguages);
    }

    public void setLanguageCollection(LanguageCollection languageCollection) throws JSONException {
        this.write("languages", languageCollection.toJson());
    }

    public boolean getPrivateSnippet() {
        return this.stringToBoolean(this.read("private_snippet"));
    }

    public void setPrivateSnippet(boolean flag) {
        this.write("private_snippet", this.booleanToString(flag));
    }

    public int getLastLanguageIndex() {
        int index;
        String value = this.read("last_language");
        try {
            index = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            index = 0;
        }
        return index;
    }

    public void setLastLanguageIndex(int lastLanguageId) {
        this.write("last_language", lastLanguageId + "");
    }

    public Date getLastUpdate() {
        long lastTime = Long.valueOf(this.read("last_update"));
        Date date = new Date();
        date.setTime(lastTime);
        return date;
    }

    public void setLastUpdate(Date date) {
        this.write("last_update", String.valueOf(date.getTime()));
    }

    public void clearAll() {
        this.unset("languages");
        this.unset("private_snippet");
        this.unset("last_language");
        this.unset("account");
        this.unset("last_update");
    }

    protected boolean stringToBoolean(String s) {
        return s.equals("1");
    }

    protected String booleanToString(boolean b) {
        return b ? "1" : "0";
    }
}

