/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin;

import com.tagmycode.plugin.EnumOS;
import com.tagmycode.plugin.Rule;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public class Browser {
    private final EnumOS os = this.guessOS();

    public boolean openUrl(String url) {
        try {
            return this.openUrl(new URI(url));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public boolean openUrl(URI uri) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(uri);
            }
            catch (IOException e) {
                return false;
            }
        } else {
            Rule rule = this.getOsBasedRule();
            return rule.browse(uri);
        }
        return false;
    }

    private Rule getOsBasedRule() {
        if (this.os.isLinux()) {
            return new LinuxRule();
        }
        if (this.os.isMac()) {
            return new MacRule();
        }
        if (this.os.isWindows()) {
            return new WindowsRule();
        }
        return new UnknownOsRule();
    }

    private EnumOS guessOS() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS.windows;
        }
        if (s.contains("mac")) {
            return EnumOS.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS.linux;
        }
        if (s.contains("unix")) {
            return EnumOS.linux;
        }
        return EnumOS.unknown;
    }

    private class UnknownOsRule
    extends Rule {
        private UnknownOsRule() {
        }

        @Override
        public boolean browse(URI uri) {
            return false;
        }
    }

    private class WindowsRule
    extends Rule {
        private WindowsRule() {
        }

        @Override
        public boolean browse(URI uri) {
            return this.runCommand("explorer", "%s", uri.toString());
        }
    }

    private class LinuxRule
    extends Rule {
        private LinuxRule() {
        }

        @Override
        public boolean browse(URI uri) {
            return this.runCommand("xdg-open", "%s", uri.toString());
        }
    }

    private class MacRule
    extends Rule {
        private MacRule() {
        }

        @Override
        public boolean browse(URI uri) {
            return this.runCommand("open", "%s", uri.toString());
        }
    }
}

