/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin;

import com.tagmycode.plugin.Browser;
import com.tagmycode.plugin.IConsole;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;

public class Console
implements IConsole {
    private JEditorPane editorPane;
    private final EditorKit editor;

    public Console(JEditorPane editorPane) {
        this.editorPane = editorPane;
        HTMLEditorKit kit = new HTMLEditorKit();
        editorPane.setEditorKit(kit);
        StyleSheet styleSheet = kit.getStyleSheet();
        styleSheet.addRule("pre {font : 10px monaco; }");
        Document doc = kit.createDefaultDocument();
        editorPane.setDocument(doc);
        editorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        new Browser().openUrl(e.getURL().toURI().toString());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                }
            }
        });
        this.editor = editorPane.getEditorKit();
    }

    @Override
    public void log(String message) {
        this.write(message);
    }

    private void write(String line) {
        SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        String nowString = df.format(Calendar.getInstance().getTime());
        StringReader reader = new StringReader("<pre>" + nowString + " - " + line);
        try {
            this.editor.read(reader, this.editorPane.getDocument(), this.editorPane.getDocument().getLength());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getFullLog() {
        return this.editorPane.getText();
    }

    public String getValue() {
        return this.editorPane.getText();
    }
}

