/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin;

import com.tagmycode.plugin.AbstractPreferences;
import com.tagmycode.plugin.AbstractSecret;
import com.tagmycode.plugin.AbstractTaskFactory;
import com.tagmycode.plugin.FrameworkConfig;
import com.tagmycode.plugin.GuiThread;
import com.tagmycode.plugin.ICallback;
import com.tagmycode.plugin.IConsole;
import com.tagmycode.plugin.IMessageManager;
import com.tagmycode.plugin.Wallet;
import com.tagmycode.plugin.exception.TagMyCodeGuiException;
import com.tagmycode.plugin.gui.AuthorizationDialog;
import com.tagmycode.plugin.gui.IDocumentInsertText;
import com.tagmycode.plugin.gui.MainWindow;
import com.tagmycode.plugin.gui.SearchSnippetDialog;
import com.tagmycode.plugin.gui.SnippetDialog;
import com.tagmycode.sdk.Client;
import com.tagmycode.sdk.TagMyCode;
import com.tagmycode.sdk.authentication.OauthToken;
import com.tagmycode.sdk.authentication.TagMyCodeApi;
import com.tagmycode.sdk.exception.TagMyCodeException;
import com.tagmycode.sdk.exception.TagMyCodeJsonException;
import com.tagmycode.sdk.exception.TagMyCodeUnauthorizedException;
import com.tagmycode.sdk.model.LanguageCollection;
import com.tagmycode.sdk.model.Snippet;
import com.tagmycode.sdk.model.User;
import java.awt.Frame;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.json.JSONException;

public class Framework {
    public static final int DAYS_BEFORE_RELOAD = 5;
    private final MainWindow mainWindow;
    private User account;
    private LanguageCollection languageCollection;
    private final Wallet wallet;
    private final Client client;
    private final TagMyCode tagMyCode;
    private final AbstractPreferences preferences;
    private final Frame mainFrame;
    private final IMessageManager messageManager;
    private final IConsole console;
    private final AbstractTaskFactory taskFactory;
    private SearchSnippetDialog searchSnippetDialog;

    public Framework(TagMyCodeApi tagMyCodeApi, FrameworkConfig frameworkConfig, AbstractSecret secret) {
        this.wallet = new Wallet(frameworkConfig.getPasswordManager());
        this.client = new Client(tagMyCodeApi, secret.getConsumerId(), secret.getConsumerSecret());
        this.tagMyCode = new TagMyCode(this.client);
        this.preferences = frameworkConfig.getPreferences();
        this.messageManager = frameworkConfig.getMessageManager();
        this.mainFrame = frameworkConfig.getMainFrame();
        this.taskFactory = frameworkConfig.getTask();
        this.mainWindow = new MainWindow(this);
        this.console = this.mainWindow.getConsole();
        this.restoreData();
        this.getConsole().log("TagMyCode started");
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public void setAccount(User account) {
        this.account = account;
    }

    public void setLanguageCollection(LanguageCollection languageCollection) {
        this.languageCollection = languageCollection;
    }

    public User getAccount() {
        return this.account;
    }

    public LanguageCollection getLanguageCollection() {
        return this.languageCollection;
    }

    public void resetData() {
        this.account = null;
        this.languageCollection = null;
    }

    public AbstractTaskFactory getTaskFactory() {
        return this.taskFactory;
    }

    public Wallet getWallet() {
        return this.wallet;
    }

    public Client getClient() {
        return this.client;
    }

    public IMessageManager getMessageManager() {
        return this.messageManager;
    }

    public OauthToken loadAccessTokenFormWallet() throws TagMyCodeGuiException {
        OauthToken oauthToken = this.wallet.loadOauthToken();
        this.client.setOauthToken(oauthToken);
        return oauthToken;
    }

    public AbstractPreferences getPreferences() {
        return this.preferences;
    }

    public void loadPreferences() throws TagMyCodeJsonException {
        this.account = this.preferences.getAccount();
        this.languageCollection = this.preferences.getLanguageCollection();
    }

    public void fetchAllData() throws TagMyCodeException {
        this.account = this.tagMyCode.getAccount();
        this.languageCollection = this.tagMyCode.getLanguages();
    }

    public void fetchAndStoreAllData() throws TagMyCodeException {
        this.fetchAllData();
        this.storeData();
    }

    public void storeData() throws TagMyCodeJsonException {
        try {
            this.preferences.setLanguageCollection(this.languageCollection);
            this.preferences.setAccount(this.account);
            this.preferences.setLastUpdate(new Date());
        }
        catch (JSONException e) {
            throw new TagMyCodeJsonException((Exception)((Object)e));
        }
    }

    public void logout() {
        this.client.revokeAccess();
        try {
            this.wallet.deleteAccessToken();
        }
        catch (TagMyCodeGuiException e) {
            this.manageTagMyCodeExceptions(e);
        }
        this.preferences.clearAll();
    }

    public void refreshDataIfItIsOld() {
        try {
            this.fetchAndStoreAllData();
            this.console.log("Data refreshed");
        }
        catch (TagMyCodeException tagMyCodeException) {
            // empty catch block
        }
    }

    public boolean isDataToBeRefreshed() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -5);
        return this.preferences.getLastUpdate().before(cal.getTime());
    }

    public boolean isRefreshable() {
        return this.client.isAuthenticated() && this.isDataToBeRefreshed();
    }

    public boolean isInitialized() {
        return this.client.isAuthenticated() && this.account != null && this.languageCollection != null;
    }

    public void showAuthenticateDialog(ICallback ... iCallback) {
        new AuthorizationDialog(this, iCallback, this.getMainFrame()).showAtCenter();
    }

    public void showSnippetDialog(Snippet snippet, String mimeType) {
        SnippetDialog snippetDialog = new SnippetDialog(this, mimeType, this.getMainFrame());
        snippetDialog.populateWithSnippet(snippet);
        snippetDialog.showAtCenter();
    }

    public void showSearchDialog(IDocumentInsertText documentUpdate) {
        if (this.searchSnippetDialog == null) {
            this.searchSnippetDialog = new SearchSnippetDialog(documentUpdate, this, this.getMainFrame());
        }
        new GuiThread().execute(new Runnable(){

            @Override
            public void run() {
                Framework.this.searchSnippetDialog.showAtCenter();
            }
        });
    }

    public Frame getMainFrame() {
        return this.mainFrame;
    }

    public void error(final String message) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Framework.this.messageManager.error(message);
            }
        });
    }

    public void error() {
        this.error(new TagMyCodeException().getMessage());
    }

    public void manageTagMyCodeExceptions(TagMyCodeException exception) {
        if (exception instanceof TagMyCodeUnauthorizedException) {
            this.logoutAndAuthenticateAgain();
        } else {
            this.error();
        }
    }

    public void logoutAndAuthenticateAgain() {
        this.logout();
        this.showAuthenticateDialog(new ICallback[0]);
    }

    public boolean canOperate() {
        if (!this.isInitialized()) {
            this.showAuthenticateDialog(new ICallback[0]);
        }
        return this.isInitialized();
    }

    public IConsole getConsole() {
        return this.console;
    }

    public void restoreData() {
        try {
            this.loadAccessTokenFormWallet();
            this.loadPreferences();
        }
        catch (TagMyCodeJsonException e) {
            this.resetData();
        }
        catch (TagMyCodeGuiException e) {
            this.manageTagMyCodeExceptions(e);
        }
    }

    public void initialize(final ICallback[] callbacks) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block6: {
                    try {
                        Framework.this.fetchAndStoreAllData();
                        Framework.this.console.log(String.format("User authenticated as <strong>%s</strong>", Framework.this.account.getEmail()));
                    }
                    catch (TagMyCodeException ex) {
                        Framework.this.manageTagMyCodeExceptions(ex);
                        Framework.this.logout();
                    }
                    finally {
                        if (callbacks == null) break block6;
                        for (ICallback callback : callbacks) {
                            callback.doOperation();
                        }
                    }
                }
            }
        };
        try {
            this.getWallet().saveOauthToken(this.client.getOauthToken());
            this.getTaskFactory().create(runnable, "Initializing TagMyCode");
        }
        catch (TagMyCodeGuiException e) {
            this.manageTagMyCodeExceptions(e);
            this.logoutAndAuthenticateAgain();
        }
    }

    public TagMyCode getTagMyCode() {
        return this.tagMyCode;
    }
}

