/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin.gui;

import com.tagmycode.plugin.Framework;
import com.tagmycode.plugin.GuiThread;
import com.tagmycode.plugin.gui.CenterLocation;
import com.tagmycode.plugin.gui.CutCopyPastePopup;
import com.tagmycode.sdk.exception.TagMyCodeException;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;

public abstract class AbstractDialog
extends JDialog {
    protected final Framework framework;
    private final Frame parentFrame;

    public AbstractDialog(Framework framework, Frame parent) {
        super(parent, true);
        this.parentFrame = parent;
        this.framework = framework;
    }

    protected abstract void initWindow();

    protected void defaultInitWindow() {
        this.setContentPane(this.getContentPanePanel());
        this.getRootPane().setDefaultButton(this.getButtonOk());
        this.getButtonOk().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.onOK();
            }
        });
        this.getButtonCancel().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AbstractDialog.this.onCancel();
            }
        });
        this.getContentPanePanel().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.initPopupMenuForJTextComponents();
    }

    private void initPopupMenuForJTextComponents() {
        ArrayList<Component> components = this.getAllComponents(this);
        for (Component component : components) {
            if (!(component instanceof JTextComponent)) continue;
            new CutCopyPastePopup((JTextComponent)component);
        }
    }

    private ArrayList<Component> getAllComponents(Container container) {
        Component[] components = container.getComponents();
        ArrayList<Component> compList = new ArrayList<Component>();
        for (Component component : components) {
            compList.add(component);
            if (!(component instanceof Container)) continue;
            compList.addAll(this.getAllComponents((Container)component));
        }
        return compList;
    }

    protected abstract void onOK();

    public abstract JButton getButtonOk();

    protected abstract JButton getButtonCancel();

    protected abstract JPanel getContentPanePanel();

    private void onCancel() {
        this.closeDialog();
    }

    public void closeDialog() {
        this.dispose();
    }

    public void showAtCenter() {
        new GuiThread().execute(new Runnable(){

            @Override
            public void run() {
                CenterLocation location = new CenterLocation(AbstractDialog.this.parentFrame, AbstractDialog.this);
                AbstractDialog.this.setLocation(location.getX(), location.getY());
                AbstractDialog.this.setVisible(true);
            }
        });
    }

    public void onError(TagMyCodeException exception) {
        this.framework.manageTagMyCodeExceptions(exception);
    }

    public Framework getFramework() {
        return this.framework;
    }
}

