/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin.gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.tagmycode.plugin.Browser;
import com.tagmycode.plugin.Framework;
import com.tagmycode.plugin.ICallback;
import com.tagmycode.plugin.exception.TagMyCodeGuiException;
import com.tagmycode.plugin.gui.AbstractDialog;
import com.tagmycode.plugin.gui.operation.FetchOauthTokenOperation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.UIManager;

public class AuthorizationDialog
extends AbstractDialog {
    private JPanel jPanelVerification;
    private JButton buttonCancel;
    private JPanel contentPane;
    private JButton buttonOK;
    private JTextField verificationCodeTextField;
    private JButton openLinkButton;
    private JTextField authorizationUrl;
    private JTextPane textHelp1;
    private JTextPane textHelp2;
    private Component JPanelVerification;
    private ICallback[] iCallback;

    public AuthorizationDialog(Framework framework, ICallback[] iCallback, Frame parent) {
        super(framework, parent);
        this.iCallback = iCallback;
        this.$$$setupUI$$$();
        this.defaultInitWindow();
        this.initWindow();
    }

    @Override
    protected void initWindow() {
        Color background = UIManager.getColor("Panel.background");
        this.contentPane.setBackground(background);
        this.textHelp1.setBackground(background);
        this.textHelp1.setForeground(SystemColor.inactiveCaption);
        this.textHelp2.setBackground(background);
        this.textHelp2.setForeground(SystemColor.inactiveCaption);
        this.authorizationUrl.setBorder(BorderFactory.createEmptyBorder());
        this.authorizationUrl.setBackground(background);
        this.authorizationUrl.setForeground(SystemColor.inactiveCaption);
        this.authorizationUrl.setText(this.framework.getClient().getAuthorizationUrl());
        this.setSize(380, 350);
        this.setResizable(false);
        this.setTitle("TagMyCode authorization");
        this.authorizationUrl.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                AuthorizationDialog.this.authorizationUrl.selectAll();
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.openLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthorizationDialog.this.onOpenLink();
            }
        });
    }

    @Override
    public JButton getButtonOk() {
        return this.buttonOK;
    }

    @Override
    protected JButton getButtonCancel() {
        return this.buttonCancel;
    }

    @Override
    protected JPanel getContentPanePanel() {
        return this.contentPane;
    }

    @Override
    protected void onOK() {
        this.buttonOK.setEnabled(false);
        try {
            this.checkVerificationCodeInput();
            this.getFetchOauthTokenOperation().run();
        }
        catch (TagMyCodeGuiException e) {
            this.onError(e);
        }
    }

    public FetchOauthTokenOperation getFetchOauthTokenOperation() {
        return new FetchOauthTokenOperation(this, this.verificationCodeTextField.getText(), this.iCallback);
    }

    private void onOpenLink() {
        new Browser().openUrl(this.authorizationUrl.getText());
        this.verificationCodeTextField.requestFocus();
    }

    private void checkVerificationCodeInput() throws TagMyCodeGuiException {
        if (this.verificationCodeTextField.getText().length() < 4) {
            this.verificationCodeTextField.requestFocus();
            this.buttonOK.setEnabled(true);
            throw new TagMyCodeGuiException("Insert a valid verification code");
        }
    }

    public JButton getOpenLinkButton() {
        return this.openLinkButton;
    }

    public JTextField getVerificationCodeTextField() {
        return this.verificationCodeTextField;
    }

    public JButton getButtonOK() {
        return this.buttonOK;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextPane jTextPane;
        JButton jButton;
        JTextField jTextField2;
        JTextPane jTextPane2;
        JPanel jPanel;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton3 = new JButton();
        jButton3.setText("OK");
        jPanel4.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton2 = new JButton();
        jButton2.setText("Cancel");
        jPanel4.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.jPanelVerification = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.textHelp1 = jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setContentType("text/plain");
        ((Component)jTextPane2).setBackground(SystemColor.window);
        jTextPane2.setText("If your browser doesn't open with the button above, please copy and paste the following url in your browser.");
        jPanel6.add((Component)jTextPane2, new GridConstraints(0, 1, 1, 3, 1, 1, 6, 6, null, new Dimension(150, 50), null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("1.");
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), 1, 20));
        jPanel7.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel7.add((Component)spacer3, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.authorizationUrl = jTextField2 = new JTextField();
        jTextField2.setText("http://");
        jTextField2.setEditable(false);
        jPanel6.add((Component)jTextField2, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.openLinkButton = jButton = new JButton();
        jButton.setText("Open link");
        Font font2 = jButton.getFont();
        jButton.setFont(new Font(font2.getName(), 1, font2.getSize()));
        jPanel6.add((Component)jButton, new GridConstraints(2, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel8, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel8.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.textHelp2 = jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setContentType("text/plain");
        jTextPane.setText("After the login you should see your verification code.");
        jPanel8.add((Component)jTextPane, new GridConstraints(0, 1, 1, 2, 1, 1, 6, 6, null, new Dimension(150, 50), null));
        this.verificationCodeTextField = jTextField = new JTextField();
        Font font3 = jTextField.getFont();
        jTextField.setFont(new Font(font3.getName(), 1, 16));
        jPanel8.add((Component)jTextField, new GridConstraints(1, 2, 1, 1, 8, 0, 6, 0, null, new Dimension(150, -1), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel8.add((Component)jPanel9, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("2.");
        Font font4 = jLabel2.getFont();
        jLabel2.setFont(new Font(font4.getName(), 1, 20));
        jPanel9.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel9.add((Component)spacer5, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Verification code:");
        jPanel8.add((Component)jLabel3, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel10, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel11, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

