/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class PopupBasicActionsEventQueue
extends EventQueue {
    public JPopupMenu popup;
    public BasicAction cut;
    public BasicAction copy;
    public BasicAction paste;
    public BasicAction selectAll;

    public void createPopupMenu(JTextComponent text) {
        this.cut = new CutAction("Cut", null);
        this.copy = new CopyAction("Copy", null);
        this.paste = new PasteAction("Paste", null);
        this.selectAll = new SelectAllAction("Select All", null);
        this.cut.setTextComponent(text);
        this.copy.setTextComponent(text);
        this.paste.setTextComponent(text);
        this.selectAll.setTextComponent(text);
        this.popup = new JPopupMenu();
        this.popup.add(this.cut);
        this.popup.add(this.copy);
        this.popup.add(this.paste);
        this.popup.addSeparator();
        this.popup.add(this.selectAll);
    }

    public void showPopup(Component parent, MouseEvent me) {
        this.popup.validate();
        this.popup.show(parent, me.getX(), me.getY());
    }

    @Override
    protected void dispatchEvent(AWTEvent event) {
        super.dispatchEvent(event);
        if (!(event instanceof MouseEvent)) {
            return;
        }
        MouseEvent me = (MouseEvent)event;
        if (!me.isPopupTrigger()) {
            return;
        }
        if (!(me.getSource() instanceof Component)) {
            return;
        }
        Component comp = SwingUtilities.getDeepestComponentAt((Component)me.getSource(), me.getX(), me.getY());
        if (!(comp instanceof JTextComponent)) {
            return;
        }
        if (MenuSelectionManager.defaultManager().getSelectedPath().length > 0) {
            return;
        }
        this.createPopupMenu((JTextComponent)comp);
        this.showPopup((Component)me.getSource(), me);
    }

    class SelectAllAction
    extends BasicAction {
        public SelectAllAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl A"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.selectAll();
        }

        @Override
        public boolean isEnabled() {
            return this.comp != null && this.comp.isEnabled() && this.comp.getText().length() > 0 && (this.comp.getSelectedText() == null || this.comp.getSelectedText().length() < this.comp.getText().length());
        }
    }

    class PasteAction
    extends BasicAction {
        public PasteAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl V"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.paste();
        }

        @Override
        public boolean isEnabled() {
            Transferable content = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            return this.comp != null && this.comp.isEnabled() && this.comp.isEditable() && content.isDataFlavorSupported(DataFlavor.stringFlavor);
        }
    }

    class CopyAction
    extends BasicAction {
        public CopyAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl C"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.copy();
        }

        @Override
        public boolean isEnabled() {
            return this.comp != null && this.comp.getSelectedText() != null;
        }
    }

    class CutAction
    extends BasicAction {
        public CutAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("ctrl X"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.comp.cut();
        }

        @Override
        public boolean isEnabled() {
            return this.comp != null && this.comp.isEditable() && this.comp.getSelectedText() != null;
        }
    }

    abstract class BasicAction
    extends AbstractAction {
        JTextComponent comp;

        public BasicAction(String text, Icon icon) {
            super(text, icon);
            this.putValue("ShortDescription", text);
        }

        public void setTextComponent(JTextComponent comp) {
            this.comp = comp;
        }

        @Override
        public abstract void actionPerformed(ActionEvent var1);
    }
}

