/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin.gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.tagmycode.plugin.Framework;
import com.tagmycode.plugin.GuiThread;
import com.tagmycode.plugin.gui.AbstractDialog;
import com.tagmycode.plugin.gui.DisabledItemSelectionModel;
import com.tagmycode.plugin.gui.IDocumentInsertText;
import com.tagmycode.plugin.gui.SnippetEditorPane;
import com.tagmycode.plugin.gui.SnippetRenderer;
import com.tagmycode.plugin.gui.operation.SearchSnippetOperation;
import com.tagmycode.sdk.model.ModelCollection;
import com.tagmycode.sdk.model.Snippet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SearchSnippetDialog
extends AbstractDialog {
    private JPanel contentPane;
    private JButton buttonOk;
    private JButton buttonCancel;
    private JTextField searchTextField;
    private SnippetEditorPane snippetEditorPane;
    private JList resultList;
    private JButton insertButton;
    private JLabel resultsFoundLabel;
    private DefaultListModel model;
    private IDocumentInsertText documentUpdate;
    private DefaultListCellRenderer defaultListCellRenderer;
    private DisabledItemSelectionModel disabledItemSelectionModel;
    private SnippetRenderer snippetRenderer;
    private DefaultListSelectionModel defaultListSelectionModel;

    public SearchSnippetDialog(IDocumentInsertText documentInsertText, Framework framework, Frame parent) {
        super(framework, parent);
        this.documentUpdate = documentInsertText;
        this.$$$setupUI$$$();
        this.defaultInitWindow();
        this.initWindow();
        this.initResultList();
        if (documentInsertText == null) {
            this.insertButton.setVisible(false);
        }
    }

    private void initResultList() {
        this.defaultListCellRenderer = new DefaultListCellRenderer();
        this.disabledItemSelectionModel = new DisabledItemSelectionModel();
        this.snippetRenderer = new SnippetRenderer();
        this.defaultListSelectionModel = new DefaultListSelectionModel();
        this.model = new DefaultListModel();
        this.resultList.setModel(this.model);
        this.resultList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Snippet snippet = SearchSnippetDialog.this.getSelectedSnippet();
                    if (snippet != null) {
                        SearchSnippetDialog.this.snippetEditorPane.setTextWithSnippet(snippet);
                        SearchSnippetDialog.this.insertButton.setEnabled(true);
                    } else {
                        SearchSnippetDialog.this.insertButton.setEnabled(false);
                    }
                }
            }
        });
        this.refreshResultsFoundLabel();
    }

    public Snippet getSelectedSnippet() {
        Snippet selectedSnippet = null;
        if (!this.resultList.isSelectionEmpty()) {
            selectedSnippet = (Snippet)this.model.getElementAt(this.resultList.getSelectedIndex());
        }
        return selectedSnippet;
    }

    private void insertText() {
        Snippet selectedSnippet = this.getSelectedSnippet();
        if (selectedSnippet != null) {
            String code = selectedSnippet.getCode();
            this.documentUpdate.insertText(code);
            this.closeDialog();
        }
    }

    @Override
    protected void initWindow() {
        this.getRootPane().setDefaultButton(null);
        this.searchTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchSnippetDialog.this.search();
            }
        });
        this.setSize(800, 400);
        this.setResizable(true);
        this.setTitle("Search snippets");
        this.buttonOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchSnippetDialog.this.search();
            }
        });
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchSnippetDialog.this.insertText();
            }
        });
        this.snippetEditorPane.setEditable(false);
        this.insertButton.setEnabled(false);
    }

    private void refreshResultsFoundLabel() {
        int size = this.resultList.getSelectionModel() == this.disabledItemSelectionModel ? 0 : this.model.getSize();
        this.resultsFoundLabel.setText(String.format("%d snippets found", size));
    }

    public DefaultListModel getModel() {
        return this.model;
    }

    @Override
    protected void onOK() {
    }

    private void search() {
        String query = this.getQuery();
        if (query.length() > 0) {
            this.clearResults();
            new SearchSnippetOperation(this, query).runWithTask(this.framework.getTaskFactory(), "Searching snippets");
        }
    }

    private void clearResults() {
        this.model.removeAllElements();
        this.snippetEditorPane.clear();
    }

    @Override
    public void closeDialog() {
        this.setVisible(false);
    }

    @Override
    public JButton getButtonOk() {
        return this.buttonOk;
    }

    @Override
    protected JButton getButtonCancel() {
        return this.buttonCancel;
    }

    @Override
    protected JPanel getContentPanePanel() {
        return this.contentPane;
    }

    public String getQuery() {
        return this.searchTextField.getText();
    }

    public void updateListWithSnippets(final ModelCollection<Snippet> snippets) {
        new GuiThread().execute(new Runnable(){

            @Override
            public void run() {
                SearchSnippetDialog.this.clearResults();
                if (snippets.size() == 0) {
                    SearchSnippetDialog.this.resultList.setCellRenderer(SearchSnippetDialog.this.defaultListCellRenderer);
                    SearchSnippetDialog.this.resultList.setSelectionModel(SearchSnippetDialog.this.disabledItemSelectionModel);
                    SearchSnippetDialog.this.model.addElement("No results found");
                } else {
                    SearchSnippetDialog.this.resultList.setCellRenderer(SearchSnippetDialog.this.snippetRenderer);
                    SearchSnippetDialog.this.resultList.setSelectionModel(SearchSnippetDialog.this.defaultListSelectionModel);
                    for (Snippet snippet : snippets) {
                        SearchSnippetDialog.this.model.addElement(snippet);
                    }
                }
                SearchSnippetDialog.this.refreshResultsFoundLabel();
            }
        });
    }

    @Override
    public void showAtCenter() {
        super.showAtCenter();
        this.searchTextField.selectAll();
        this.searchTextField.requestFocus();
    }

    public JTextField getSearchTextBox() {
        return this.searchTextField;
    }

    public JButton getSearchButton() {
        return this.buttonOk;
    }

    public JButton getInsertButton() {
        return this.insertButton;
    }

    public JList getResultList() {
        return this.resultList;
    }

    public JLabel getResultsFoundLabel() {
        return this.resultsFoundLabel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SnippetEditorPane snippetEditorPane;
        JList jList;
        JButton jButton;
        JTextField jTextField;
        JLabel jLabel;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 3, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonCancel = jButton3 = new JButton();
        jButton3.setText("Close");
        jPanel3.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.insertButton = jButton2 = new JButton();
        jButton2.setText("Insert at cursor");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.resultsFoundLabel = jLabel = new JLabel();
        jLabel.setText("0 snippets found");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 10, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, "North");
        this.searchTextField = jTextField = new JTextField();
        jPanel5.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, 26), null));
        this.buttonOk = jButton = new JButton();
        jButton.setText("Search");
        jPanel5.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, "Center");
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(256);
        jSplitPane.setDividerSize(10);
        jPanel6.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JScrollPane jScrollPane = new JScrollPane();
        jSplitPane.setLeftComponent(jScrollPane);
        this.resultList = jList = new JList();
        jScrollPane.setViewportView(jList);
        JScrollPane jScrollPane2 = new JScrollPane();
        jSplitPane.setRightComponent(jScrollPane2);
        this.snippetEditorPane = snippetEditorPane = new SnippetEditorPane();
        jScrollPane2.setViewportView(snippetEditorPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

