/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin.gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.tagmycode.plugin.Framework;
import com.tagmycode.plugin.GuiThread;
import com.tagmycode.plugin.ICallback;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SettingsForm {
    private JPanel mainPanel;
    private JPanel loginPanel;
    private JPanel logoutPanel;
    private JButton loginButton;
    private JButton logoutButton;
    private JLabel identity;
    private Framework framework;

    public SettingsForm(final Framework framework) {
        this.framework = framework;
        this.$$$setupUI$$$();
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                framework.showAuthenticateDialog(new ICallback(){

                    @Override
                    public void doOperation() {
                        SettingsForm.this.refreshPanelInGuiThread();
                    }
                });
            }
        });
        this.logoutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                framework.logout();
                framework.getConsole().log("User log out");
                SettingsForm.this.refreshPanelInGuiThread();
            }
        });
        this.doRefreshPanel();
    }

    private void refreshPanelInGuiThread() {
        new GuiThread().execute(new Runnable(){

            @Override
            public void run() {
                SettingsForm.this.doRefreshPanel();
            }
        });
    }

    private void doRefreshPanel() {
        if (this.framework.isInitialized()) {
            this.identity.setText(this.framework.getAccount().getEmail());
            this.loginPanel.setVisible(false);
            this.logoutPanel.setVisible(true);
        } else {
            this.loginPanel.setVisible(true);
            this.logoutPanel.setVisible(false);
        }
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public JPanel getLoginPanel() {
        return this.loginPanel;
    }

    public JPanel getLogoutPanel() {
        return this.logoutPanel;
    }

    public JButton getLoginButton() {
        return this.loginButton;
    }

    public JButton getLogoutButton() {
        return this.logoutButton;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JLabel jLabel;
        JPanel jPanel;
        JButton jButton2;
        JPanel jPanel2;
        JPanel jPanel3;
        this.mainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.loginPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel2).setEnabled(false);
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.loginButton = jButton2 = new JButton();
        jButton2.setText("Sign in");
        jPanel2.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.logoutPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        ((Component)jPanel).setEnabled(false);
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Logged as: ");
        jPanel4.add((Component)jLabel2, "West");
        this.identity = jLabel = new JLabel();
        Font font = jLabel.getFont();
        jLabel.setFont(new Font(font.getName(), 1, font.getSize()));
        jLabel.setHorizontalAlignment(2);
        jLabel.setText("identity");
        jPanel4.add((Component)jLabel, "Center");
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, "East");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.logoutButton = jButton = new JButton();
        jButton.setText("Sign out");
        jPanel5.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel5.add((Component)spacer4, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel5.add((Component)spacer5, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel3.add((Component)spacer6, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

