/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin.gui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.tagmycode.plugin.Framework;
import com.tagmycode.plugin.GuiThread;
import com.tagmycode.plugin.gui.AbstractDialog;
import com.tagmycode.plugin.gui.SnippetEditorPane;
import com.tagmycode.plugin.gui.operation.CreateSnippetOperation;
import com.tagmycode.sdk.model.Language;
import com.tagmycode.sdk.model.Snippet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class SnippetDialog
extends AbstractDialog {
    private JPanel contentPane;
    private JTextField tagsTextField;
    private JCheckBox privateSnippetCheckBox;
    private JTextField descriptionTextField;
    private JTextField titleBox;
    private SnippetEditorPane codeEditorPane;
    private JComboBox languageComboBox;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JPanel jpanel;
    private JScrollPane scrollPane;

    public SnippetDialog(Framework framework, String mimeType, Frame parent) {
        super(framework, parent);
        this.$$$setupUI$$$();
        this.defaultInitWindow();
        this.initWindow();
        this.setMimeType(mimeType);
    }

    public void populateWithSnippet(Snippet snippet) {
        this.titleBox.setText(snippet.getTitle());
        this.descriptionTextField.setText(snippet.getDescription());
        this.tagsTextField.setText(snippet.getTags());
        this.codeEditorPane.setTextWithSnippet(snippet);
    }

    @Override
    protected void initWindow() {
        this.descriptionTextField.requestFocus();
        this.setSize(650, 450);
        this.setTitle("Create snippet");
        this.setResizable(true);
        new GuiThread().execute(new Runnable(){

            @Override
            public void run() {
                SnippetDialog.this.populateLanguages();
                SnippetDialog.this.restorePreferences();
                SnippetDialog.this.listenForChanges();
            }
        });
    }

    @Override
    protected void onOK() {
        new CreateSnippetOperation(this).runWithTask(this.framework.getTaskFactory(), "Saving snippet");
    }

    @Override
    public JButton getButtonOk() {
        return this.buttonOK;
    }

    @Override
    protected JButton getButtonCancel() {
        return this.buttonCancel;
    }

    @Override
    protected JPanel getContentPanePanel() {
        return this.contentPane;
    }

    private void populateLanguages() {
        if (this.framework.getLanguageCollection() != null) {
            for (Language l : this.framework.getLanguageCollection()) {
                this.languageComboBox.addItem(l);
            }
        }
    }

    private void listenForChanges() {
        this.languageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = SnippetDialog.this.languageComboBox.getSelectedIndex();
                SnippetDialog.this.framework.getPreferences().setLastLanguageIndex(selectedIndex);
            }
        });
        this.privateSnippetCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = SnippetDialog.this.privateSnippetCheckBox.isSelected();
                SnippetDialog.this.framework.getPreferences().setPrivateSnippet(selected);
            }
        });
    }

    private void restorePreferences() {
        new GuiThread().execute(new Runnable(){

            @Override
            public void run() {
                boolean privateSnippet = SnippetDialog.this.framework.getPreferences().getPrivateSnippet();
                SnippetDialog.this.privateSnippetCheckBox.setSelected(privateSnippet);
                try {
                    int lastLanguageIndex = SnippetDialog.this.framework.getPreferences().getLastLanguageIndex();
                    SnippetDialog.this.languageComboBox.setSelectedIndex(lastLanguageIndex);
                }
                catch (Exception e) {
                    SnippetDialog.this.framework.getPreferences().setLastLanguageIndex(0);
                }
            }
        });
    }

    @Override
    public JPanel getContentPane() {
        return this.contentPane;
    }

    public Snippet getSnippet() {
        Snippet snippet = new Snippet();
        snippet.setCode(this.codeEditorPane.getText());
        snippet.setLanguage((Language)this.languageComboBox.getSelectedItem());
        snippet.setTitle(this.titleBox.getText());
        snippet.setDescription(this.descriptionTextField.getText());
        snippet.setTags(this.tagsTextField.getText());
        snippet.setPrivate(this.privateSnippetCheckBox.isSelected());
        return snippet;
    }

    public JComboBox getLanguageComboBox() {
        return this.languageComboBox;
    }

    public void setMimeType(String mimeType) {
        this.codeEditorPane.setContentType(mimeType);
    }

    public JEditorPane getCodeEditorPane() {
        return this.codeEditorPane;
    }

    public JTextField getTagsTextField() {
        return this.tagsTextField;
    }

    public JTextField getDescriptionTextField() {
        return this.descriptionTextField;
    }

    public JTextField getTitleBox() {
        return this.titleBox;
    }

    public JCheckBox getPrivateSnippetCheckBox() {
        return this.privateSnippetCheckBox;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        SnippetEditorPane snippetEditorPane;
        JTextField jTextField;
        JComboBox jComboBox;
        JTextField jTextField2;
        JCheckBox jCheckBox;
        JTextField jTextField3;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 2, 1, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Tags:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.tagsTextField = jTextField3 = new JTextField();
        jPanel2.add((Component)jTextField3, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.privateSnippetCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Private snippet");
        jPanel2.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Title:");
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.titleBox = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Language:");
        jPanel4.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.languageComboBox = jComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel4.add(jComboBox, new GridConstraints(0, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Description:");
        jPanel3.add((Component)jLabel4, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.descriptionTextField = jTextField = new JTextField();
        jTextField.setText("");
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.codeEditorPane = snippetEditorPane = new SnippetEditorPane();
        jScrollPane.setViewportView(snippetEditorPane);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton2 = new JButton();
        jButton2.setText("OK");
        jPanel7.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton = new JButton();
        jButton.setText("Cancel");
        jPanel7.add((Component)jButton, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }
}

