/*
 * Decompiled with CFR 0.152.
 */
package com.tagmycode.plugin.gui.operation;

import com.tagmycode.plugin.AbstractTaskFactory;
import com.tagmycode.plugin.gui.AbstractDialog;
import com.tagmycode.sdk.exception.TagMyCodeException;
import javax.swing.SwingUtilities;

public abstract class TagMyCodeAsynchronousOperation<T> {
    protected AbstractDialog abstractDialog;

    public TagMyCodeAsynchronousOperation(AbstractDialog abstractDialog) {
        this.abstractDialog = abstractDialog;
    }

    public final void run() {
        Runnable runnable = this.getRunnable();
        new Thread(runnable).start();
    }

    public void runWithTask(AbstractTaskFactory task, String title) {
        task.create(this.getRunnable(), title);
    }

    private Runnable getRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TagMyCodeAsynchronousOperation.this.beforePerformOperation();
                        }
                    });
                    final Object result = TagMyCodeAsynchronousOperation.this.performOperation();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TagMyCodeAsynchronousOperation.this.onComplete();
                            TagMyCodeAsynchronousOperation.this.onSuccess(result);
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (Throwable e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TagMyCodeAsynchronousOperation.this.onComplete();
                            TagMyCodeAsynchronousOperation.this.onFailure(e);
                            e.printStackTrace();
                        }
                    });
                }
            }
        };
    }

    protected void beforePerformOperation() {
    }

    protected abstract T performOperation() throws Exception;

    protected void onComplete() {
    }

    protected void onSuccess(T result) {
    }

    protected void onFailure(Throwable e) {
        if (e instanceof TagMyCodeException) {
            this.abstractDialog.onError((TagMyCodeException)e);
        } else {
            this.abstractDialog.onError(new TagMyCodeException());
        }
    }
}

