/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.Code;
import com.tagtraum.japlscript.Id;
import com.tagtraum.japlscript.Inherits;
import com.tagtraum.japlscript.JaplEnum;
import com.tagtraum.japlscript.Kind;
import com.tagtraum.japlscript.Name;
import com.tagtraum.japlscript.Parameters;
import com.tagtraum.japlscript.Plural;
import com.tagtraum.japlscript.Reference;
import com.tagtraum.japlscript.Type;
import com.tagtraum.japlscript.Types;
import com.tagtraum.japlscript.types.TypeClass;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Generator
extends Task {
    private static final String SDEF_DTD = "file://localhost/System/Library/DTDs/sdef.dtd";
    private Path sdef;
    private String packagePrefix = "com.tagtraum.japlscript";
    private Path out = Paths.get(".", new String[0]);
    private final Map<String, String> customTypeMapping = new HashMap<String, String>();
    private Map<String, List<Element>> classMap;
    private Map<String, List<Element>> enumerationMap;
    private final Set<String> excludeClassSet = new HashSet<String>();

    public void addConfiguredTypeMapping(TypeMapping typeMapping) {
        this.customTypeMapping.put(typeMapping.getApplescript(), typeMapping.getJava());
    }

    public void addConfiguredExcludeClass(ExcludeClass excludeClass) {
        this.excludeClassSet.add(excludeClass.getName());
    }

    public Path getSdef() {
        return this.sdef;
    }

    public void setSdef(File sdef) {
        this.sdef = sdef.toPath();
    }

    public void setSdef(Path sdef) {
        this.sdef = sdef;
    }

    public String getPackagePrefix() {
        return this.packagePrefix;
    }

    public void setPackagePrefix(String packagePrefix) {
        this.packagePrefix = packagePrefix.endsWith(".") ? packagePrefix.substring(0, packagePrefix.length() - 1) : packagePrefix;
    }

    public Path getOut() {
        return this.out;
    }

    public void setOut(File out) {
        this.out = out.toPath();
    }

    public void setOut(Path out) {
        this.out = out;
    }

    private String getPackageName() {
        String filename = this.sdef.getFileName().toString();
        int lastDot = filename.lastIndexOf(46);
        if (lastDot != -1) {
            filename = filename.substring(0, lastDot);
        }
        return this.toPackageName(filename);
    }

    public void execute() {
        try {
            this.generate();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void generate() throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (Generator.SDEF_DTD.equals(systemId)) {
                    InputStream sdefDTD = this.getClass().getResourceAsStream("sdef.dtd");
                    assert (sdefDTD != null);
                    return new InputSource(sdefDTD);
                }
                return null;
            }
        });
        Document sdefDocument = documentBuilder.parse(this.sdef.toFile());
        this.buildClassMap(sdefDocument);
        this.buildEnumerationMap(sdefDocument);
        for (Map.Entry<String, List<Element>> entry : this.classMap.entrySet()) {
            if (this.excludeClassSet.contains(entry.getKey())) continue;
            this.writeClass(entry.getValue());
        }
        NodeList enumerations = sdefDocument.getElementsByTagName("enumeration");
        int enumerationsLength = enumerations.getLength();
        for (int j = 0; j < enumerationsLength; ++j) {
            Element enumeration = (Element)enumerations.item(j);
            this.writeEnumeration(enumeration);
        }
    }

    private void buildEnumerationMap(Document sdefDocument) {
        NodeList enumerations = sdefDocument.getElementsByTagName("enumeration");
        int enumerationsLength = enumerations.getLength();
        this.enumerationMap = new HashMap<String, List<Element>>();
        for (int j = 0; j < enumerationsLength; ++j) {
            Element enumeration = (Element)enumerations.item(j);
            String enumerationName = enumeration.getAttribute("name");
            List list = this.enumerationMap.computeIfAbsent(enumerationName, k -> new ArrayList());
            list.add(enumeration);
        }
    }

    private void buildClassMap(Document sdefDocument) {
        NodeList classes = sdefDocument.getElementsByTagName("class");
        int classesLength = classes.getLength();
        this.classMap = new HashMap<String, List<Element>>();
        for (int j = 0; j < classesLength; ++j) {
            Element klass = (Element)classes.item(j);
            String className = klass.getAttribute("name");
            List list = this.classMap.computeIfAbsent(className, k -> new ArrayList());
            list.add(klass);
        }
        NodeList extensions = sdefDocument.getElementsByTagName("class-extension");
        int extensionsLength = extensions.getLength();
        for (int j = 0; j < extensionsLength; ++j) {
            Element klass = (Element)extensions.item(j);
            String className = klass.getAttribute("extends");
            List list = this.classMap.computeIfAbsent(className, k -> new ArrayList());
            list.add(klass);
        }
    }

    private void writeEnumeration(Element enumeration) throws IOException {
        String className = enumeration.getAttribute("name");
        String fullyQualifiedClassName = this.toFullyQualifiedClassName(className);
        String javaClassName = this.getJavaType(className);
        Path classFile = this.createClassFile(fullyQualifiedClassName);
        Files.createDirectories(classFile.getParent(), new FileAttribute[0]);
        try (BufferedWriter streamWriter = Files.newBufferedWriter(classFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            Element enumerator;
            int i;
            PrintWriter writer = new PrintWriter(streamWriter);
            String packageName = this.getPackageName();
            writer.println("package " + packageName + ";");
            writer.println();
            writer.println("/**");
            writer.println(" * " + enumeration.getAttribute("description"));
            writer.println(" */");
            if (enumeration.getAttribute("code") != "") {
                writer.println("@" + Code.class.getName() + "(\"" + enumeration.getAttribute("code") + "\")");
            }
            if (className != "") {
                writer.println("@" + Name.class.getName() + "(\"" + className + "\")");
            }
            writer.println("public enum " + javaClassName + " implements " + JaplEnum.class.getName() + " {");
            writer.println();
            NodeList enumerators = enumeration.getElementsByTagName("enumerator");
            for (i = 0; i < enumerators.getLength(); ++i) {
                enumerator = (Element)enumerators.item(i);
                this.writeEnumerator(writer, enumerator);
                if (i + 1 < enumerators.getLength()) {
                    writer.println(",");
                    continue;
                }
                writer.println(";");
            }
            writer.println();
            writer.println("private final String name;");
            writer.println("private final String code;");
            writer.println("private final String description;");
            writer.println();
            writer.println("private " + javaClassName + "(final String name, final String code, final String description) {");
            writer.println("    this.name = name;");
            writer.println("    this.code = code;");
            writer.println("    this.description = description;");
            writer.println("}");
            writer.println();
            writer.println("@Override");
            writer.println("public String getName() { return this.name;}");
            writer.println();
            writer.println("@Override");
            writer.println("public String getCode() { return this.code;}");
            writer.println();
            writer.println("@Override");
            writer.println("public String getDescription() { return this.description;}");
            writer.println();
            writer.println("/**");
            writer.println(" * Get instance for name.");
            writer.println(" */");
            writer.println("public static " + javaClassName + " get(final String name) {");
            for (i = 0; i < enumerators.getLength(); ++i) {
                enumerator = (Element)enumerators.item(i);
                String name = enumerator.getAttribute("name");
                String code = enumerator.getAttribute("code");
                String javaName = Types.toJavaConstant(name);
                if (i != 0) {
                    writer.print("    else ");
                } else {
                    writer.print("    ");
                }
                writer.println("if (\"" + code + "\".equals(name) || \"" + name + "\".equals(name) || \"\u00abconstant ****" + code + "\u00bb\".equals(name)) return " + javaName + ";");
            }
            writer.println("    else throw new " + IllegalArgumentException.class.getName() + "(\"Enum \" + name + \" is unknown.\");");
            writer.println("}");
            writer.println();
            writer.println("}");
            writer.flush();
        }
    }

    private void writeEnumerator(PrintWriter writer, Element enumerator) {
        String name = enumerator.getAttribute("name");
        String code = enumerator.getAttribute("code");
        String description = enumerator.getAttribute("description") == "" ? "null" : "\"" + enumerator.getAttribute("description") + "\"";
        String javaName = Types.toJavaConstant(name);
        writer.print("    " + javaName + "(\"" + name + "\", \"" + code + "\", " + description + ")");
    }

    private void writeClass(List<Element> classList) throws IOException {
        Element klass = classList.get(0);
        String className = klass.getAttribute("name") != null && klass.getAttribute("name").length() > 0 ? klass.getAttribute("name") : klass.getAttribute("extends");
        String fullyQualifiedClassName = this.toFullyQualifiedClassName(className);
        String javaClassName = Types.toCamelCaseClassName(className);
        Path classFile = this.createClassFile(fullyQualifiedClassName);
        Files.createDirectories(classFile.getParent(), new FileAttribute[0]);
        HashSet<MethodSignature> methodSignatures = new HashSet<MethodSignature>();
        try (BufferedWriter streamWriter = Files.newBufferedWriter(classFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            PrintWriter writer = new PrintWriter(streamWriter);
            String packageName = this.getPackageName();
            writer.println("package " + packageName + ";");
            writer.println();
            writer.println("/**");
            writer.println(" * " + Generator.toJavadocDescription(klass.getAttribute("description")));
            writer.println(" */");
            String superClass = klass.getAttribute("inherits");
            String code = "null";
            String typeSuperClass = "null";
            if (klass.getAttribute("plural") != "") {
                writer.println("@" + Plural.class.getName() + "(\"" + klass.getAttribute("plural") + "\")");
            }
            if (klass.getAttribute("code") != "") {
                code = "\"\\u00abclass " + klass.getAttribute("code") + "\\u00bb\"";
            }
            writer.println("@" + Code.class.getName() + "(\"" + klass.getAttribute("code") + "\")");
            if (className != "") {
                writer.println("@" + Name.class.getName() + "(\"" + className + "\")");
            }
            if (superClass != "") {
                writer.println("@" + Inherits.class.getName() + "(\"" + superClass + "\")");
            }
            writer.print("public interface " + javaClassName + " extends " + Reference.class.getName());
            if (superClass != "" && !superClass.equals(className)) {
                String additionalSuperClass = this.getJavaType(superClass);
                if (!Reference.class.getName().equals(additionalSuperClass)) {
                    writer.print(", " + additionalSuperClass);
                    typeSuperClass = additionalSuperClass + ".CLASS";
                }
            }
            writer.println(" {");
            writer.println();
            writer.println("public static final " + TypeClass.class.getName() + " CLASS = " + TypeClass.class.getName() + ".getInstance(\"" + className + "\", " + code + ", null, " + typeSuperClass + ");");
            if ("application".equals(className)) {
                this.writeCommands(writer, klass.getOwnerDocument(), methodSignatures);
            }
            for (Element classElement : classList) {
                NodeList elements = classElement.getElementsByTagName("element");
                for (int i = 0; i < elements.getLength(); ++i) {
                    Element element = (Element)elements.item(i);
                    this.writeElement(writer, element, methodSignatures);
                }
                NodeList properties = classElement.getElementsByTagName("property");
                for (int i = 0; i < properties.getLength(); ++i) {
                    Element property = (Element)properties.item(i);
                    this.writeProperty(writer, property, methodSignatures);
                }
            }
            writer.println();
            writer.println("}");
            writer.flush();
        }
    }

    private void writeCommands(PrintWriter writer, Document document, Set<MethodSignature> methodSignatures) {
        NodeList commands = document.getElementsByTagName("command");
        for (int i = 0; i < commands.getLength(); ++i) {
            Element command = (Element)commands.item(i);
            this.writeCommand(writer, command, methodSignatures);
        }
    }

    private void writeCommand(PrintWriter w, Element command, Set<MethodSignature> methodSignatures) {
        String parameterType;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        String name = command.getAttribute("name");
        String description = command.getAttribute("description");
        writer.println();
        writer.println("/**");
        writer.println(" * " + Generator.toJavadocDescription(description));
        writer.println(" *");
        NodeList children = command.getChildNodes();
        ArrayList<String> javaParameterNames = new ArrayList<String>();
        ArrayList<String> parameterNames = new ArrayList<String>();
        ArrayList<String> parameterTypes = new ArrayList<String>();
        ArrayList<Boolean> parameterArray = new ArrayList<Boolean>();
        boolean hasResult = false;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            boolean isArray = false;
            Element element = (Element)child;
            if ("access-group".equals(element.getTagName()) || "cocoa".equals(element.getTagName()) || "synonym".equals(element.getTagName())) continue;
            parameterType = element.getAttribute("type");
            String parameterDescription = element.getAttribute("description");
            if (parameterType == null || parameterType.length() == 0) {
                NodeList types = element.getElementsByTagName("type");
                if (types.getLength() > 1) {
                    this.log("Cannot generate code for commands with multiple types. Command: " + name);
                    this.log("Will skip further commands with other parameters.");
                }
                if (types.getLength() >= 1) {
                    Element typeElement = (Element)types.item(0);
                    parameterType = typeElement.getAttribute("type");
                    isArray = "yes".equals(typeElement.getAttribute("list"));
                }
            }
            String javaParameterName = Generator.getParameterName(javaParameterNames, parameterDescription, parameterType, isArray);
            javaParameterNames.add(javaParameterName);
            parameterTypes.add(parameterType);
            parameterArray.add(isArray);
            if ("direct-parameter".equals(element.getTagName())) {
                writer.println(" * @param " + javaParameterName + " " + parameterDescription);
                parameterNames.add("");
                continue;
            }
            if ("parameter".equals(element.getTagName())) {
                writer.println(" * @param " + javaParameterName + " " + parameterDescription);
                parameterNames.add(element.getAttribute("name"));
                continue;
            }
            if (!"result".equals(element.getTagName())) continue;
            writer.println(" * @return " + parameterDescription);
            hasResult = true;
        }
        int parameterCount = hasResult ? parameterTypes.size() - 1 : parameterTypes.size();
        writer.println(" */");
        writer.println("@" + Kind.class.getName() + "(\"command\")");
        writer.println("@" + Name.class.getName() + "(\"" + name + "\")");
        writer.print("@" + Parameters.class.getName() + "({");
        for (int i = 0; i < parameterNames.size(); ++i) {
            String parameterName = (String)parameterNames.get(i);
            writer.print("\"" + parameterName + "\"");
            if (i + 1 >= parameterNames.size()) continue;
            writer.print(", ");
        }
        writer.println("})");
        MethodSignature methodSignature = new MethodSignature();
        writer.print("public ");
        if (hasResult) {
            String returnType = this.getJavaType((String)parameterTypes.get(parameterTypes.size() - 1));
            if (((Boolean)parameterArray.get(parameterArray.size() - 1)).booleanValue()) {
                returnType = returnType + "[]";
            }
            writer.print(returnType);
            writer.print(" ");
            methodSignature.setReturnType(returnType);
        } else {
            writer.print("void ");
            methodSignature.setReturnType("void");
        }
        String methodName = Types.toCamelCaseMethodName(name);
        methodSignature.setName(methodName);
        writer.print(methodName + "(");
        for (int i = 0; i < parameterCount; ++i) {
            parameterType = this.getJavaType((String)parameterTypes.get(i));
            if (((Boolean)parameterArray.get(i)).booleanValue()) {
                parameterType = parameterType + "[]";
            }
            writer.print(parameterType);
            writer.print(" ");
            writer.print((String)javaParameterNames.get(i));
            if (i + 1 < parameterCount) {
                writer.print(", ");
            }
            methodSignature.addParameterType(parameterType);
        }
        writer.println(");");
        if ("make".equals(name)) {
            writer.println();
            writer.println("/**");
            writer.println(" * Creates a new object.");
            writer.println(" * " + Generator.toJavadocDescription(description));
            writer.println(" *");
            writer.println(" * @param klass Java type of the object to create.");
            writer.println(" * @return a new object of type klass");
            writer.println(" */");
            writer.println("@" + Kind.class.getName() + "(\"make\")");
            writer.println("public <T extends " + Reference.class.getName() + "> T make(Class<T> klass);");
        }
        writer.flush();
        if (!methodSignatures.contains(methodSignature)) {
            w.write(stringWriter.toString());
            methodSignatures.add(methodSignature);
        } else {
            this.log("Skipping method " + methodSignature + " since it is already declared.");
        }
    }

    private static String getParameterName(List<String> usedNames, String description, String type, boolean isArray) {
        String newName;
        if (description != null && description.length() > 0) {
            String newBaseName;
            newName = newBaseName = Types.toCamelCaseMethodName(description);
            int i = 0;
            while (usedNames.contains(newName)) {
                newName = newBaseName + i;
                ++i;
            }
        } else {
            String newBaseName = Types.toCamelCaseMethodName(type);
            if (isArray) {
                newBaseName = newBaseName + "s";
            }
            newName = newBaseName;
            int i = 0;
            while (usedNames.contains(newName)) {
                newName = newBaseName + i;
                ++i;
            }
        }
        return newName;
    }

    private void writeElement(PrintWriter w, Element element, Set<MethodSignature> methodSignatures) {
        MethodSignature methodSignature;
        PrintWriter writer;
        StringWriter stringWriter;
        String type = element.getAttribute("type");
        String javaClassName = this.getJavaType(type);
        String propertyName = Types.toCamelCaseClassName(type);
        String access = element.getAttribute("access") == "" ? "rw" : element.getAttribute("access");
        String description = element.getAttribute("description");
        if (access.indexOf(114) != -1) {
            stringWriter = new StringWriter();
            writer = new PrintWriter(stringWriter);
            writer.println();
            writer.println("/**");
            writer.println(" * " + Generator.toJavadocDescription(description));
            writer.println(" * @return an array of all {@link " + javaClassName + "}s");
            writer.println(" */");
            writer.println("@" + Kind.class.getName() + "(\"element\")");
            if (type != "") {
                writer.println("@" + Type.class.getName() + "(\"" + type + "\")");
            }
            writer.println("public " + javaClassName + "[] get" + propertyName + "s();");
            writer.println();
            writer.println("/**");
            writer.println(" * " + Generator.toJavadocDescription(description));
            writer.println(" * @param filter AppleScript filter clause without the leading \"whose\" or \"where\"");
            writer.println(" * @return a filtered array of {@link " + javaClassName + "}s");
            writer.println(" */");
            writer.println("@" + Kind.class.getName() + "(\"element\")");
            if (type != "") {
                writer.println("@" + Type.class.getName() + "(\"" + type + "\")");
            }
            writer.println("public " + javaClassName + "[] get" + propertyName + "s(String filter);");
            writer.println();
            writer.println("/**");
            writer.println(" * " + Generator.toJavadocDescription(description));
            writer.println(" * @param index index into the element list");
            writer.println(" * @return the {@link " + javaClassName + "} with at the requested index");
            writer.println(" */");
            if (type != "") {
                writer.println("@" + Type.class.getName() + "(\"" + type + "\")");
            }
            writer.println("@" + Kind.class.getName() + "(\"element\")");
            writer.println("public " + javaClassName + " get" + propertyName + "(int index);");
            writer.println();
            writer.println("/**");
            writer.println(" * " + Generator.toJavadocDescription(description));
            writer.println(" * @param id id of the item");
            writer.println(" * @return the {@link " + javaClassName + "} with the requested id");
            writer.println(" */");
            if (type != "") {
                writer.println("@" + Type.class.getName() + "(\"" + type + "\")");
            }
            writer.println("@" + Kind.class.getName() + "(\"element\")");
            writer.println("public " + javaClassName + " get" + propertyName + "(" + Id.class.getName() + " id);");
            writer.println();
            writer.println("/**");
            writer.println(" * " + Generator.toJavadocDescription(description));
            writer.println(" * @return number of all {@link " + javaClassName + "}s");
            writer.println(" */");
            if (type != "") {
                writer.println("@" + Type.class.getName() + "(\"" + type + "\")");
            }
            writer.println("@" + Kind.class.getName() + "(\"element\")");
            writer.println("public int count" + propertyName + "s();");
            writer.println();
            writer.println("/**");
            writer.println(" * " + Generator.toJavadocDescription(description));
            writer.println(" * @param filter AppleScript filter clause without the leading \"whose\" or \"where\"");
            writer.println(" * @return the number of elements that pass the filter");
            writer.println(" */");
            writer.println("@" + Kind.class.getName() + "(\"element\")");
            if (type != "") {
                writer.println("@" + Type.class.getName() + "(\"" + type + "\")");
            }
            writer.println("public int count" + propertyName + "s(String filter);");
            methodSignature = new MethodSignature();
            methodSignature.setReturnType(javaClassName + "[]");
            methodSignature.setName("get" + propertyName);
            if (!methodSignatures.contains(methodSignature)) {
                w.write(stringWriter.toString());
                methodSignatures.add(methodSignature);
            } else {
                this.log("Skipping element " + type + " since it is already declared.");
            }
        }
        if (access.indexOf(119) != -1) {
            stringWriter = new StringWriter();
            writer = new PrintWriter(stringWriter);
            writer.println();
            writer.println("/**");
            writer.println(" * " + Generator.toJavadocDescription(description));
            writer.println(" * @param value element to set in the list");
            writer.println(" * @param index index into the element list");
            writer.println(" */");
            if (type != "") {
                writer.println("@" + Type.class.getName() + "(\"" + type + "\")");
            }
            writer.println("@" + Kind.class.getName() + "(\"element\")");
            writer.println("public void set" + propertyName + "(" + javaClassName + " value, int index);");
            methodSignature = new MethodSignature();
            methodSignature.setReturnType("void");
            methodSignature.setName("set" + propertyName);
            methodSignature.addParameterType(javaClassName);
            methodSignature.addParameterType("int");
            if (!methodSignatures.contains(methodSignature)) {
                w.write(stringWriter.toString());
                methodSignatures.add(methodSignature);
            } else {
                this.log("Skipping element " + type + " since it is already declared.");
            }
        }
    }

    private void writeProperty(PrintWriter w, Element property, Set<MethodSignature> methodSignatures) {
        MethodSignature methodSignature;
        PrintWriter writer;
        StringWriter stringWriter;
        String name = property.getAttribute("name");
        String type = property.getAttribute("type");
        boolean isArray = false;
        if (type == null || type.length() == 0) {
            NodeList types = property.getElementsByTagName("type");
            if (types.getLength() > 1) {
                throw new RuntimeException("Cannot generate code for properties with multiple types. Property: " + name);
            }
            if (types.getLength() == 1) {
                Element typeElement = (Element)types.item(0);
                type = typeElement.getAttribute("type");
                isArray = "yes".equals(typeElement.getAttribute("list"));
            }
        }
        String code = property.getAttribute("code");
        String array = isArray ? "[]" : "";
        String javaClassName = this.getJavaType(type) + array;
        String javaPropertyName = this.avoidForbiddenMethodNames(Types.toCamelCaseClassName(name));
        String access = property.getAttribute("access") == "" ? "rw" : property.getAttribute("access");
        String description = property.getAttribute("description");
        if (access.indexOf(114) != -1) {
            stringWriter = new StringWriter();
            writer = new PrintWriter(stringWriter);
            writer.println();
            writer.println("/**");
            writer.println(" * " + Generator.toJavadocDescription(description));
            writer.println(" */");
            if (type != "") {
                writer.println("@" + Type.class.getName() + "(\"" + type + "\")");
            }
            if (name != "") {
                writer.println("@" + Name.class.getName() + "(\"" + name + "\")");
            }
            if (code != "") {
                writer.println("@" + Code.class.getName() + "(\"" + code + "\")");
            }
            writer.println("@" + Kind.class.getName() + "(\"property\")");
            writer.println("public " + javaClassName + " get" + javaPropertyName + "();");
            writer.flush();
            methodSignature = new MethodSignature();
            methodSignature.setReturnType(javaClassName);
            methodSignature.setName("get" + javaPropertyName);
            if (!methodSignatures.contains(methodSignature)) {
                w.write(stringWriter.toString());
                methodSignatures.add(methodSignature);
            } else {
                this.log("Skipping method " + methodSignature + " since it is already declared.");
            }
        }
        if (access.indexOf(119) != -1) {
            stringWriter = new StringWriter();
            writer = new PrintWriter(stringWriter);
            writer.println();
            writer.println("/**");
            writer.println(" * " + Generator.toJavadocDescription(description));
            writer.println(" */");
            if (type != "") {
                writer.println("@" + Type.class.getName() + "(\"" + type + "\")");
            }
            if (name != "") {
                writer.println("@" + Name.class.getName() + "(\"" + name + "\")");
            }
            if (code != "") {
                writer.println("@" + Code.class.getName() + "(\"" + code + "\")");
            }
            writer.println("@" + Kind.class.getName() + "(\"property\")");
            writer.println("public void set" + javaPropertyName + "(" + javaClassName + " object);");
            writer.flush();
            methodSignature = new MethodSignature();
            methodSignature.setReturnType("void");
            methodSignature.setName("set" + javaPropertyName);
            methodSignature.addParameterType(javaClassName);
            if (!methodSignatures.contains(methodSignature)) {
                w.write(stringWriter.toString());
                methodSignatures.add(methodSignature);
            } else {
                this.log("Skipping method " + methodSignature + " since it is already declared.");
            }
        }
    }

    private String avoidForbiddenMethodNames(String name) {
        if ("Class".equals(name)) {
            return "Klass";
        }
        return name;
    }

    private Path createClassFile(String className) {
        return this.out.resolve(Generator.classToFile(className));
    }

    private String toFullyQualifiedClassName(String className) {
        return this.getPackageName() + "." + Types.toCamelCaseClassName(className);
    }

    private String toPackageName(String sdefName) {
        return this.packagePrefix + "." + Generator.sdefNameToPackageName(sdefName);
    }

    private String getJavaType(String applescriptType) {
        String javaType = this.customTypeMapping.get(applescriptType);
        if (javaType == null && (javaType = Types.getStandardJavaType(applescriptType)) == null) {
            if (this.classMap.containsKey(applescriptType)) {
                javaType = Types.toCamelCaseClassName(applescriptType);
            } else if (this.enumerationMap.containsKey(applescriptType)) {
                javaType = Types.toCamelCaseClassName(applescriptType);
            } else {
                this.log("Warning: Unable to resolve Applescript class '" + applescriptType + "'. Will use plain Reference instead.");
                javaType = Reference.class.getName();
            }
        }
        return javaType;
    }

    private static String sdefNameToPackageName(String suiteName) {
        return suiteName.toLowerCase().replace(' ', '_');
    }

    private static String classToFile(String packageName) {
        return packageName.replace('.', '/') + ".java";
    }

    private static String toJavadocDescription(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s.length() + 1);
        sb.append(Character.toUpperCase(s.charAt(0)));
        sb.append(s.substring(1));
        if (!(s.endsWith(".") || s.endsWith("?") || s.endsWith("!"))) {
            sb.append('.');
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        Generator generator = new Generator();
        generator.setSdef(new File(args[0]).toPath());
        generator.setOut(Paths.get("out", new String[0]));
        generator.generate();
    }

    private static class MethodSignature {
        private String returnType = "";
        private String name = "";
        private final List<String> parameterTypes = new ArrayList<String>();

        public String getReturnType() {
            return this.returnType;
        }

        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void addParameterType(String type) {
            this.parameterTypes.add(type);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MethodSignature)) {
                return false;
            }
            if (obj == null) {
                return false;
            }
            MethodSignature that = (MethodSignature)obj;
            return this.name.equals(that.name) && this.returnType.equals(that.returnType) && this.parameterTypes.equals(that.parameterTypes);
        }

        public String toString() {
            return this.returnType + " " + this.name + " " + this.parameterTypes;
        }
    }

    public static class ExcludeClass {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class TypeMapping {
        private String applescript;
        private String java;

        public String getApplescript() {
            return this.applescript;
        }

        public void setApplescript(String applescript) {
            this.applescript = applescript;
        }

        public String getJava() {
            return this.java;
        }

        public void setJava(String java) {
            this.java = java;
        }
    }
}

