/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.Aspect;
import com.tagtraum.japlscript.DateParser;
import com.tagtraum.japlscript.JaplEnum;
import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.ObjectInvocationHandler;
import com.tagtraum.japlscript.Reference;
import com.tagtraum.japlscript.Session;
import com.tagtraum.japlscript.types.Alias;
import com.tagtraum.japlscript.types.Data;
import com.tagtraum.japlscript.types.JaplScriptFile;
import com.tagtraum.japlscript.types.Picture;
import com.tagtraum.japlscript.types.ReferenceImpl;
import com.tagtraum.japlscript.types.Tdta;
import com.tagtraum.japlscript.types.TypeClass;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaplScript {
    private static final Logger LOG = LoggerFactory.getLogger(JaplScript.class);
    private static final int LAST_ASCII_CHAR = 127;
    private static List<Aspect> globalAspects = new ArrayList<Aspect>();

    private JaplScript() {
    }

    public static void addGlobalAspect(Aspect aspect) {
        globalAspects.add(aspect);
    }

    public static boolean removeGlobalAspect(Aspect aspect) {
        return globalAspects.remove(aspect);
    }

    public static List<Aspect> getGlobalAspects() {
        return new ArrayList<Aspect>(globalAspects);
    }

    public static Session startSession() {
        Session session = Session.getSession();
        if (session == null) {
            session = new Session();
        }
        return session;
    }

    public static <T> T getApplication(Class<T> interfaceClass, String applicationName) {
        ReferenceImpl reference = new ReferenceImpl(null, "application \"" + applicationName + "\"");
        return JaplScript.cast(interfaceClass, reference);
    }

    public static <T> T cast(Class<T> interfaceClass, Reference reference) {
        if (reference == null) {
            return null;
        }
        try {
            String objectReference = reference.getObjectReference();
            String applicationReference = reference.getApplicationReference();
            if (interfaceClass == String.class) {
                String trimmed = objectReference;
                if (trimmed != null && trimmed.startsWith("\"") && trimmed.endsWith("\"")) {
                    trimmed = trimmed.substring(1, trimmed.length() - 1);
                }
                return (T)trimmed;
            }
            if (interfaceClass == Integer.TYPE) {
                return (T)Integer.valueOf(Integer.parseInt(objectReference));
            }
            if (interfaceClass == Boolean.TYPE) {
                return (T)Boolean.valueOf(Boolean.parseBoolean(objectReference));
            }
            if (interfaceClass == Float.TYPE) {
                return (T)Float.valueOf(Float.parseFloat(objectReference));
            }
            if (interfaceClass == Double.TYPE) {
                return (T)Double.valueOf(Double.parseDouble(objectReference));
            }
            if (interfaceClass == Long.TYPE) {
                return (T)Long.valueOf(Long.parseLong(objectReference));
            }
            if (interfaceClass == Date.class) {
                if (objectReference == null) {
                    return null;
                }
                return (T)JaplScript.parseDate(objectReference);
            }
            if (interfaceClass == Alias.class) {
                if (objectReference == null) {
                    return null;
                }
                return (T)new Alias(objectReference, applicationReference);
            }
            if (interfaceClass == Data.class) {
                if (objectReference == null) {
                    return null;
                }
                return (T)new Data(objectReference, applicationReference);
            }
            if (interfaceClass == Picture.class) {
                if (objectReference == null) {
                    return null;
                }
                return (T)new Picture(objectReference, applicationReference);
            }
            if (interfaceClass == Tdta.class) {
                if (objectReference == null) {
                    return null;
                }
                return (T)new Tdta(objectReference, applicationReference);
            }
            if (interfaceClass == JaplScriptFile.class) {
                if (objectReference == null) {
                    return null;
                }
                return (T)new JaplScriptFile(objectReference, applicationReference);
            }
            if (interfaceClass == TypeClass.class) {
                if (objectReference == null) {
                    return null;
                }
                return (T)new TypeClass(objectReference, applicationReference);
            }
            if (interfaceClass.isArray()) {
                if (objectReference == null) {
                    return null;
                }
                return (T)JaplScript.parseList(interfaceClass.getComponentType(), reference);
            }
            if (objectReference != null && objectReference.trim().length() == 0) {
                return null;
            }
            if (JaplEnum.class.isAssignableFrom(interfaceClass)) {
                try {
                    Method getMethod = interfaceClass.getMethod("get", String.class);
                    return (T)getMethod.invoke(null, objectReference);
                }
                catch (Exception e) {
                    throw new JaplScriptException(e);
                }
            }
            if (!interfaceClass.isInterface()) {
                if (objectReference != null) {
                    throw new JaplScriptException("Cannot create proxy for non-interface class " + interfaceClass);
                }
                LOG.warn("Attempt to cast " + reference + " to unregistered class type " + interfaceClass + ". As the object reference is null, we simply default to also returning null. Consider adding " + interfaceClass + " to known cast types.");
                return null;
            }
            return (T)Proxy.newProxyInstance(JaplScript.class.getClassLoader(), new Class[]{interfaceClass}, (InvocationHandler)new ObjectInvocationHandler(reference));
        }
        catch (JaplScriptException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new JaplScriptException("Failed to cast " + reference + " to " + interfaceClass);
        }
    }

    private static Date parseDate(String objectReference) {
        SimpleDateFormat rfc3339Format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        rfc3339Format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return rfc3339Format.parse(objectReference);
        }
        catch (ParseException parseException) {
            int firstQuote = objectReference.indexOf(34);
            int lastQuote = objectReference.lastIndexOf(34);
            if (firstQuote < 0 || lastQuote < 0) {
                throw new JaplScriptException("Failed to parse date: " + objectReference);
            }
            String d = objectReference.substring(firstQuote + 1, lastQuote);
            try {
                return new DateParser(Locale.getDefault()).parse(d);
            }
            catch (ParseException parseException2) {
                try {
                    return new DateParser(Locale.US).parse(d);
                }
                catch (ParseException parseException3) {
                    int format;
                    for (format = 0; format <= 3; ++format) {
                        try {
                            return DateFormat.getDateTimeInstance(format, format, Locale.US).parse(d);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    for (format = 0; format <= 3; ++format) {
                        try {
                            return DateFormat.getDateTimeInstance(format, format, Locale.getDefault()).parse(d);
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    throw new JaplScriptException("Failed to parse date: " + objectReference);
                }
            }
        }
    }

    private static <T> T[] parseList(Class<T> interfaceClass, Reference reference) {
        String objectReference = reference.getObjectReference();
        String applicationReference = reference.getApplicationReference();
        ArrayList<T> result = new ArrayList<T>();
        int depth = 0;
        boolean curlies = objectReference.startsWith("{");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < objectReference.length(); ++i) {
            boolean lastChar;
            char c = objectReference.charAt(i);
            switch (c) {
                case '{': {
                    ++depth;
                    break;
                }
                case '}': {
                    --depth;
                    break;
                }
            }
            boolean bl = lastChar = i == objectReference.length() - 1;
            if (depth == 1 && c == ',' || depth == 0 && c == '}' || !curlies && (c == ',' || lastChar)) {
                if (!curlies && lastChar) {
                    sb.append(c);
                }
                if (sb.length() <= 0) continue;
                result.add(JaplScript.cast(interfaceClass, new ReferenceImpl(sb.toString(), applicationReference)));
                sb.setLength(0);
                continue;
            }
            if (depth == 1 && c != '{') {
                sb.append(c);
                continue;
            }
            if (!curlies) {
                sb.append(c);
                continue;
            }
            if (depth <= 1) continue;
            sb.append(c);
        }
        return result.toArray((Object[])Array.newInstance(interfaceClass, result.size()));
    }

    public static String asUnicodeText(String s) {
        try {
            byte[] buf;
            StringBuilder sb = new StringBuilder();
            sb.append("(\u00abdata utf8");
            for (byte b : buf = s.getBytes("utf8")) {
                int i = b & 0xFF;
                String hex = Integer.toHexString(i);
                if (hex.length() == 1) {
                    sb.append('0');
                }
                sb.append(hex);
            }
            sb.append("\u00bb as Unicode text)");
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new JaplScriptException(e);
        }
    }

    public static String quote(String s) {
        StringBuilder sb = new StringBuilder();
        sb.append("(\"");
        int unicodeStart = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c > '\u007f') {
                if (unicodeStart != -1) continue;
                unicodeStart = i;
                continue;
            }
            if (unicodeStart != -1) {
                sb.append("\" & ");
                sb.append(JaplScript.asUnicodeText(s.substring(unicodeStart, i)));
                sb.append(" & \"");
                unicodeStart = -1;
            }
            switch (c) {
                case '\"': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        if (unicodeStart != -1) {
            sb.append("\" & ");
            sb.append(JaplScript.asUnicodeText(s.substring(unicodeStart)));
            sb.append(")");
        } else {
            sb.append("\")");
        }
        return sb.toString();
    }

    static {
        globalAspects.add(new DateHelper());
        globalAspects.add(new Tell());
    }

    private static class DateHelper
    implements Aspect {
        private DateHelper() {
        }

        @Override
        public String before(String application, String body) {
            return null;
        }

        @Override
        public String after(String application, String body) {
            if (body.contains("my createDate")) {
                return "on createDate(y, m, d, h, min, s)\n\tset dateVar to (current date)\n\tset year of dateVar to y\n\tset month of dateVar to m\n\tset day of dateVar to d\n\tset hours of dateVar to h\n\tset minutes of dateVar to min\n\tset seconds of dateVar to s\n\treturn dateVar\nend createDate";
            }
            return null;
        }
    }

    private static class Tell
    implements Aspect {
        private Tell() {
        }

        @Override
        public String before(String application, String body) {
            return "tell " + application;
        }

        @Override
        public String after(String application, String body) {
            return "end tell";
        }
    }
}

