/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JaplScriptException
extends RuntimeException {
    private String error;
    private String script;

    public JaplScriptException(Throwable throwable) {
        super(throwable);
        this.error = this.getMessage();
    }

    public JaplScriptException(String errorMessage, String script) {
        super(JaplScriptException.convertUnicode(errorMessage) + "\nScript:\n" + script);
        this.script = script;
        this.error = JaplScriptException.convertUnicode(errorMessage);
    }

    public JaplScriptException(String message) {
        super(JaplScriptException.convertUnicode(message));
        this.error = JaplScriptException.convertUnicode(message);
    }

    public JaplScriptException(String errorMessage, Throwable cause) {
        super(JaplScriptException.convertUnicode(errorMessage), cause);
        this.error = JaplScriptException.convertUnicode(errorMessage);
    }

    public String getError() {
        return this.error;
    }

    public String getScript() {
        return this.script;
    }

    private static String convertUnicode(String s) {
        Pattern pattern = Pattern.compile("\\\\U[0-9[a-f][A-F]]{4}");
        Matcher matcher = pattern.matcher(s);
        HashSet<String> unicodeSequence = new HashSet<String>();
        while (matcher.find()) {
            unicodeSequence.add(matcher.group());
        }
        String result = s;
        for (String unicode : unicodeSequence) {
            char c = (char)Integer.parseInt(unicode.substring(2), 16);
            result = result.replaceAll("\\" + unicode, Character.toString(c));
        }
        return result;
    }
}

