/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.Aspect;
import com.tagtraum.japlscript.Id;
import com.tagtraum.japlscript.JaplEnum;
import com.tagtraum.japlscript.JaplScript;
import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.Kind;
import com.tagtraum.japlscript.Name;
import com.tagtraum.japlscript.Parameters;
import com.tagtraum.japlscript.Plural;
import com.tagtraum.japlscript.Reference;
import com.tagtraum.japlscript.ScriptExecutor;
import com.tagtraum.japlscript.Session;
import com.tagtraum.japlscript.Type;
import com.tagtraum.japlscript.types.ReferenceImpl;
import com.tagtraum.japlscript.types.TypeClass;
import java.awt.Point;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectInvocationHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectInvocationHandler.class);
    private static final Method TO_STRING_METHOD;
    private static final Method EQUALS_METHOD;
    private static final Method HASHCODE_METHOD;
    private static final Method OBJECT_REFERENCE_METHOD;
    private static final Method APPLICATION_REFERENCE_METHOD;
    private static final Method CAST_METHOD;
    private static final Method IS_INSTANCE_OF_METHOD;
    private Reference reference;
    private boolean reduceScriptExecutions = true;

    public ObjectInvocationHandler(Reference reference) {
        this.reference = reference;
    }

    public boolean isReduceScriptExecutions() {
        return this.reduceScriptExecutions;
    }

    public void setReduceScriptExecutions(boolean reduceScriptExecutions) {
        this.reduceScriptExecutions = reduceScriptExecutions;
    }

    public TypeClass getTypeClass() {
        try {
            return this.executeAppleScript(this.reference, "return class of " + this.reference.getObjectReference(), TypeClass.class);
        }
        catch (IOException e) {
            throw new JaplScriptException(e);
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object returnValue = null;
            if (method.equals(TO_STRING_METHOD)) {
                return this.toString(this.reference);
            }
            if (method.equals(OBJECT_REFERENCE_METHOD)) {
                return this.reference.getObjectReference();
            }
            if (method.equals(EQUALS_METHOD)) {
                return this.equals(this.reference, args[0]);
            }
            if (method.equals(HASHCODE_METHOD)) {
                return this.reference.hashCode();
            }
            if (method.equals(APPLICATION_REFERENCE_METHOD)) {
                return this.reference.getApplicationReference();
            }
            if (method.equals(CAST_METHOD)) {
                return JaplScript.cast((Class)args[0], this.reference);
            }
            if (method.equals(IS_INSTANCE_OF_METHOD)) {
                return args.length == 1 && args[0] != null && ((TypeClass)args[0]).isInstance(this.reference);
            }
            Kind kind = method.getAnnotation(Kind.class);
            if ("element".equals(kind.value())) {
                returnValue = this.invokeElement(method, method.getReturnType(), args);
            } else if ("property".equals(kind.value())) {
                returnValue = this.invokeProperty(method, method.getReturnType(), args);
            } else if ("command".equals(kind.value())) {
                returnValue = this.invokeCommand(method, method.getReturnType(), args);
            } else if ("make".equals(kind.value())) {
                returnValue = this.invokeMake(args);
            }
            return returnValue;
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception e) {
            throw new JaplScriptException(e);
        }
    }

    private String toString(Reference reference) {
        return "[" + reference.getApplicationReference() + "]: " + reference.getObjectReference();
    }

    private boolean equals(Reference ref1, Object ref2) {
        if (ref2 == null) {
            return false;
        }
        if (!(ref2 instanceof Reference)) {
            return false;
        }
        return this.toString(ref1).equals(this.toString((Reference)ref2));
    }

    private <T> T invokeMake(Object ... args) throws IOException {
        Class klass = (Class)args[0];
        Name applescriptClassname = klass.getAnnotation(Name.class);
        String applescript = "make " + applescriptClassname.value();
        return this.executeAppleScript(this.reference, applescript, klass);
    }

    private <T> T invokeCommand(Method method, Class<T> returnType, Object ... args) throws IOException {
        Name name = method.getAnnotation(Name.class);
        Parameters parameters = method.getAnnotation(Parameters.class);
        StringBuilder applescript = new StringBuilder(name.value() + " ");
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                if (arg == null) continue;
                applescript.append(parameters.value()[i]).append(' ');
                applescript.append(ObjectInvocationHandler.encode(arg));
                applescript.append(" ");
            }
        }
        return this.executeAppleScript(this.reference, applescript.toString(), returnType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T invokeElement(Method method, Class<T> returnType, Object ... args) throws IOException, NoSuchMethodException {
        T returnValue = null;
        Type type = method.getAnnotation(Type.class);
        if (method.getName().startsWith("get")) {
            if (method.getReturnType().isArray()) {
                if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == String.class) {
                    String plural = method.getReturnType().getComponentType().getAnnotation(Plural.class).value();
                    String applescript = "return " + plural + this.getOfClause() + " where " + args[0];
                    returnValue = this.executeAppleScript(this.reference, applescript, returnType);
                    return returnValue;
                } else {
                    if (method.getParameterTypes().length != 0) throw new JaplScriptException("Unknown method signature. " + method);
                    String plural = method.getReturnType().getComponentType().getAnnotation(Plural.class).value();
                    String applescript = "return " + plural + this.getOfClause();
                    returnValue = this.executeAppleScript(this.reference, applescript, returnType);
                }
                return returnValue;
            } else if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Integer.TYPE) {
                String plural = method.getReturnType().getAnnotation(Plural.class).value();
                int index = (Integer)args[0] + 1;
                String objectreference = "item " + index + " of " + plural + this.getOfClause();
                if (this.reduceScriptExecutions) {
                    if (index < 1) {
                        throw new ArrayIndexOutOfBoundsException("Index has to be greater than 0");
                    }
                    returnValue = JaplScript.cast(returnType, new ReferenceImpl(objectreference, this.reference.getApplicationReference()));
                    return returnValue;
                } else {
                    String applescript = "return " + objectreference;
                    returnValue = this.executeAppleScript(this.reference, applescript, returnType);
                }
                return returnValue;
            } else {
                if (method.getParameterTypes().length != 1 || method.getParameterTypes()[0] != Id.class) throw new JaplScriptException("Unknown method signature. " + method);
                Id id = (Id)args[0];
                String objectreference = type.value() + " " + id + this.getOfClause();
                if (this.reduceScriptExecutions) {
                    returnValue = JaplScript.cast(returnType, new ReferenceImpl(objectreference, this.reference.getApplicationReference()));
                    return returnValue;
                } else {
                    String applescript = "return " + objectreference;
                    returnValue = this.executeAppleScript(this.reference, applescript, returnType);
                }
            }
            return returnValue;
        } else {
            if (!method.getName().startsWith("count")) return returnValue;
            Method getMethod = method.getDeclaringClass().getMethod("get" + method.getName().substring("count".length()), new Class[0]);
            String plural = getMethod.getReturnType().getComponentType().getAnnotation(Plural.class).value();
            if (method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == String.class) {
                String applescript = "count " + plural + this.getOfClause() + " where " + args[0];
                returnValue = this.executeAppleScript(this.reference, applescript, returnType);
                return returnValue;
            } else {
                if (method.getParameterTypes().length != 0) throw new JaplScriptException("Unknown method signature. " + method);
                String applescript = "count " + plural + this.getOfClause();
                returnValue = this.executeAppleScript(this.reference, applescript, returnType);
            }
        }
        return returnValue;
    }

    private <T> T invokeProperty(Method method, Class<T> returnType, Object[] args) throws IOException {
        T returnValue = null;
        Name name = method.getAnnotation(Name.class);
        if (method.getName().startsWith("get")) {
            String applescript = "return " + name.value() + this.getOfClause();
            returnValue = this.executeAppleScript(this.reference, applescript, returnType);
        } else if (method.getName().startsWith("set")) {
            String applescript = "set " + name.value() + this.getOfClause() + " to " + ObjectInvocationHandler.encode(args[0]);
            returnValue = this.executeAppleScript(this.reference, applescript, returnType);
        }
        return returnValue;
    }

    private String getOfClause() {
        if (this.reference.getObjectReference() == null) {
            return "";
        }
        return " of " + this.reference.getObjectReference();
    }

    private static String encode(Object arg) {
        if (arg instanceof Object[]) {
            return ObjectInvocationHandler.encode((Object[])arg);
        }
        if (arg instanceof Point) {
            Point p = (Point)arg;
            return "{" + p.x + ", " + p.y + "}";
        }
        if (arg instanceof String) {
            return JaplScript.quote((String)arg);
        }
        if (arg instanceof Reference) {
            return ((Reference)arg).getObjectReference();
        }
        if (arg instanceof JaplEnum) {
            return ((JaplEnum)arg).getName();
        }
        if (arg instanceof Date) {
            Date date = (Date)arg;
            SimpleDateFormat dateHelperFormat = new SimpleDateFormat("'my createDate('yyyy, M, d, H, m, s')'");
            return dateHelperFormat.format(date);
        }
        return arg.toString();
    }

    private static String encode(Object[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (int i = 0; i < array.length; ++i) {
            sb.append(ObjectInvocationHandler.encode(array[i]));
            if (i + 1 >= array.length) continue;
            sb.append(", ");
        }
        sb.append('}');
        return sb.toString();
    }

    public <T> T executeAppleScript(Reference reference, String appleScript, Class<T> returnType) throws IOException {
        return this.executeAppleScript(reference.getApplicationReference(), appleScript, returnType);
    }

    private <T> T executeAppleScript(String application, String appleScript, Class<T> returnType) throws IOException {
        return this.executeAppleScript(this.tell(application, appleScript), returnType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeAppleScript(CharSequence appleScript, Class<T> returnType) throws IOException {
        Session session = Session.getSession();
        if (session == null) {
            ScriptExecutor scriptExecutor = ScriptExecutor.newInstance();
            scriptExecutor.setScript(appleScript);
            String returnValue = scriptExecutor.execute();
            if (!returnType.equals(Void.TYPE)) {
                return JaplScript.cast(returnType, new ReferenceImpl(returnValue, this.reference.getApplicationReference()));
            }
            return null;
        }
        if (!returnType.equals(Void.TYPE) && !session.isIgnoreReturnValues()) {
            try {
                session.add(appleScript);
                ScriptExecutor scriptExecutor = ScriptExecutor.newInstance();
                scriptExecutor.setScript(session.getScript());
                String returnValue = scriptExecutor.execute();
                T t = JaplScript.cast(returnType, new ReferenceImpl(returnValue, this.reference.getApplicationReference()));
                return t;
            }
            finally {
                session.reset();
            }
        }
        session.add(appleScript);
        return null;
    }

    private CharSequence tell(String application, String appleScript) {
        StringBuilder sb = new StringBuilder();
        List<Aspect> globalAspects = JaplScript.getGlobalAspects();
        for (Aspect aspect : globalAspects) {
            String before = aspect.before(application, appleScript);
            if (before == null) continue;
            sb.append(before).append("\r\n");
        }
        Session session = Session.getSession();
        if (session != null) {
            List<Aspect> aspects = session.getAspects();
            for (Aspect aspect : aspects) {
                String before = aspect.before(application, appleScript);
                if (before == null) continue;
                sb.append("  ").append(before).append("\r\n");
            }
            sb.append("  ").append(appleScript).append("\r\n");
            Collections.reverse(aspects);
            for (Aspect aspect : aspects) {
                String after = aspect.after(application, appleScript);
                if (after == null) continue;
                sb.append("  ").append(after).append("\r\n");
            }
        } else {
            sb.append(appleScript).append("\r\n");
        }
        Collections.reverse(globalAspects);
        for (Aspect aspect : globalAspects) {
            String after = aspect.after(application, appleScript);
            if (after == null) continue;
            sb.append(after).append("\r\n");
        }
        return sb.toString();
    }

    static {
        try {
            TO_STRING_METHOD = Object.class.getMethod("toString", new Class[0]);
            HASHCODE_METHOD = Object.class.getMethod("hashCode", new Class[0]);
            EQUALS_METHOD = Object.class.getMethod("equals", Object.class);
            OBJECT_REFERENCE_METHOD = Reference.class.getMethod("getObjectReference", new Class[0]);
            APPLICATION_REFERENCE_METHOD = Reference.class.getMethod("getApplicationReference", new Class[0]);
            CAST_METHOD = Reference.class.getMethod("cast", Class.class);
            IS_INSTANCE_OF_METHOD = Reference.class.getMethod("isInstanceOf", TypeClass.class);
        }
        catch (NoSuchMethodException e) {
            throw new Error(e);
        }
    }
}

