/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.ExecutionEvent;
import com.tagtraum.japlscript.ExecutionListener;
import com.tagtraum.japlscript.execution.CocoaScriptExecutor;
import com.tagtraum.japlscript.execution.Osascript;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptExecutor {
    private static final Logger LOG;
    private static final List<ExecutionListener> listeners;
    private static boolean cocoaScriptExecutor;
    private CharSequence script;
    public static final int MAX_RETURNVALUE_LOG_LENGTH = 1024;

    public static void addExecutionListener(ExecutionListener listener) {
        listeners.add(listener);
    }

    public static boolean removeExecutionListener(ExecutionListener listener) {
        return listeners.remove(listener);
    }

    public void setScript(CharSequence script) {
        this.script = script;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Script: " + script);
        }
    }

    public CharSequence getScript() {
        return this.script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws IOException {
        String script = this.getScript().toString();
        ExecutionEvent startEvent = new ExecutionEvent(this, script, true, null);
        SwingUtilities.invokeLater(() -> {
            for (ExecutionListener l : listeners) {
                l.executing(startEvent);
            }
        });
        String result = null;
        try {
            String string = result = this.executeImpl();
            return string;
        }
        finally {
            ExecutionEvent stopEvent = new ExecutionEvent(this, script, false, result);
            SwingUtilities.invokeLater(() -> {
                for (ExecutionListener l : listeners) {
                    l.executing(stopEvent);
                }
            });
        }
    }

    protected abstract String executeImpl() throws IOException;

    public static ScriptExecutor newInstance() {
        if (cocoaScriptExecutor) {
            return new CocoaScriptExecutor();
        }
        return new Osascript();
    }

    static {
        block3: {
            LOG = LoggerFactory.getLogger(ScriptExecutor.class);
            listeners = new ArrayList<ExecutionListener>();
            try {
                new CocoaScriptExecutor();
                cocoaScriptExecutor = true;
                if (LOG.isInfoEnabled()) {
                    LOG.info("Cocoa AppleScript support active.");
                }
            }
            catch (Throwable t) {
                cocoaScriptExecutor = false;
                if (!LOG.isInfoEnabled()) break block3;
                LOG.info("Cocoa AppleScript support not available. Will use Osascript.");
            }
        }
    }
}

