/*
 * Decompiled with CFR 0.152.
 */
package com.tagtraum.japlscript;

import com.tagtraum.japlscript.Aspect;
import com.tagtraum.japlscript.JaplScriptException;
import com.tagtraum.japlscript.ScriptExecutor;
import com.tagtraum.japlscript.Timeout;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Session {
    private static final ThreadLocal<Session> SESSIONS = new ThreadLocal();
    public static final int DEFAULT_TIMEOUT = -1;
    private StringBuilder script;
    private boolean ignoreReturnValues;
    private boolean compile;
    private int timeout = -1;
    private List<Aspect> aspects = new ArrayList<Aspect>();

    Session() {
        SESSIONS.set(this);
        this.reset();
    }

    public void addAspect(Aspect aspect) {
        this.aspects.add(aspect);
    }

    public boolean removeAspect(Aspect aspect) {
        return this.aspects.remove(aspect);
    }

    public List<Aspect> getAspects() {
        return new ArrayList<Aspect>(this.aspects);
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        Iterator<Aspect> iterator = this.aspects.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof Timeout)) continue;
            iterator.remove();
        }
        if (timeout > 0) {
            this.aspects.add(0, new Timeout(timeout));
        }
        this.timeout = timeout;
    }

    public boolean isDefaultTimeout() {
        return this.timeout <= 0;
    }

    public boolean isIgnoreReturnValues() {
        return this.ignoreReturnValues;
    }

    public void setIgnoreReturnValues(boolean ignoreReturnValues) {
        this.ignoreReturnValues = ignoreReturnValues;
    }

    public boolean isCompile() {
        return this.compile;
    }

    public void setCompile(boolean compile) {
        this.compile = compile;
    }

    public void add(CharSequence applescriptFragment) {
        if (Session.getSession() == null) {
            throw new IllegalStateException("Session already committed.");
        }
        this.script.append(applescriptFragment).append("\n");
    }

    public void reset() {
        this.script = new StringBuilder();
        this.timeout = -1;
    }

    public String getScript() {
        return this.script.toString();
    }

    public void commit() {
        try {
            if (this.script.length() > 0) {
                ScriptExecutor scriptExecutor = ScriptExecutor.newInstance();
                scriptExecutor.setScript(this.script);
                scriptExecutor.execute();
            }
        }
        catch (IOException e) {
            throw new JaplScriptException(e);
        }
        finally {
            this.script = new StringBuilder();
            SESSIONS.remove();
        }
    }

    public static Session getSession() {
        return SESSIONS.get();
    }
}

